/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.Expression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.LiteralExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import java.util.List;
import java.util.stream.Collectors;

public class ConnectorResolverBuilder {
    public <T extends ResolverDefinition<T>> ResolverReference<T> buildResolverReference(ResolverReferenceDescriptor<?> resolverReferenceDescriptor, T definition) {
        List<Argument> resolverArguments = resolverReferenceDescriptor.getArguments().stream().map(x -> new Argument(x.getName(), this.buildLiteralExpression(x.getValue()))).collect(Collectors.toList());
        return new ResolverReference<T>(this.buildResolverDeclaration(resolverReferenceDescriptor.getDeclaration(), definition), resolverArguments);
    }

    public <T extends ResolverDefinition<T>> ResolverDeclaration<T> buildResolverDeclaration(ResolverDeclarationDescriptor<?> resolverDeclarationDescriptor, T definition) {
        List<ResolverParameter> parameters = resolverDeclarationDescriptor.getParameters().stream().map(this::buildResolverParameter).collect(Collectors.toList());
        return new ResolverDeclaration<T>(resolverDeclarationDescriptor.getName(), definition, parameters);
    }

    private ResolverParameter buildResolverParameter(ResolverParameterDescriptor resolverParameterDescriptor) {
        return new ResolverParameter(resolverParameterDescriptor.getName(), ParameterDataType.forName(resolverParameterDescriptor.getDataType().getName()));
    }

    private Expression buildLiteralExpression(String expressionContent) {
        return new LiteralExpression(expressionContent);
    }
}

