/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.simpledata.SimpleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.simpledata.SimpleDataDefinitionDescriptor;

public class ConnectorSimpleDataBuilder {

  private final ConnectorResolverBuilder connectorResolverBuilder = new ConnectorResolverBuilder();
  private final ConnectorDataExpressionBuilder connectorDataExpressionBuilder = new ConnectorDataExpressionBuilder();

  public ResolverExpression<SimpleDataDefinition> buildSimpleData(ResolverExpressionDescriptor<SimpleDataDefinitionDescriptor> simpleDataExpressionDescriptor) {
    if (simpleDataExpressionDescriptor == null) {
      return null;
    }

    if (simpleDataExpressionDescriptor instanceof ResolverReferenceDescriptor<?>) {
      ResolverReferenceDescriptor<SimpleDataDefinitionDescriptor> resolverReference =
          (ResolverReferenceDescriptor<SimpleDataDefinitionDescriptor>) simpleDataExpressionDescriptor;

      return connectorResolverBuilder
          .buildResolverReference(resolverReference,
                                  buildSimpleDataDefinition(resolverReference.getDeclaration().getDefinition()));

    } else if (simpleDataExpressionDescriptor instanceof ResolverDefinitionDescriptor<?>) {
      return buildSimpleDataDefinition((SimpleDataDefinitionDescriptor) simpleDataExpressionDescriptor);
    }

    throw new IllegalArgumentException("ResolverExpressionDescriptor not supported, this is a bug.");
  }

  private SimpleDataDefinition buildSimpleDataDefinition(SimpleDataDefinitionDescriptor simpleDataDefinitionDescriptor) {
    return new SimpleDataDefinition(connectorDataExpressionBuilder
        .buildDataExpression(simpleDataDefinitionDescriptor.getResult()));
  }
}
