/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

public class PartParameter extends Parameter {

  private final boolean isFilePart;

  public PartParameter(String displayName, String externalName, TypeDefinition typeDefinition, String description,
                       boolean isFilePart) {
    super(buildInternalName(externalName), displayName, externalName, typeDefinition, description, false, null, false, null);
    this.isFilePart = isFilePart;
  }

  private static String buildInternalName(String externalName) {
    return getXmlName(externalName) + "-" + getXmlName(ParameterType.PART.getName());
  }

  public boolean isFilePart() {
    return isFilePart;
  }
}
