/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver;

import java.util.List;

public class ResolverDeclaration<T extends ResolverDefinition<T>> implements ResolverExpression<T> {

  /*** Declaration name */
  private final String name;

  private final List<ResolverParameter> parameters;

  private final T resolverDefinition;

  public ResolverDeclaration(String name,
                             T resolverDefinition,
                             List<ResolverParameter> parameters) {
    this.name = name;
    this.parameters = parameters;
    this.resolverDefinition = resolverDefinition;
  }

  public String getName() {
    return name;
  }

  public List<ResolverParameter> getParameters() {
    return parameters;
  }

  public T getResolverDefinition() {
    return resolverDefinition;
  }
}
