/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod.GET;
import static com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataTypeDescriptor.SAME_OPERATION;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SampleDataDescriptor;

public class SampleDataBuilderUtil {

  public static boolean shouldHaveSampleData(SampleDataDescriptor sampleDataDescriptor, String method) {
    return sampleDataDescriptor != null
        && sampleDataDescriptor.getType().equals(SAME_OPERATION)
        && HTTPMethod.fromString(method).equals(GET);
  }
}
