/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorArgumentBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.DataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.DataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionDescriptor;

public class ConnectorDataExpressionBuilder {
    private final ConnectorArgumentBuilder connectorArgumentBuilder = new ConnectorArgumentBuilder();

    public DataExpression buildDataExpression(DataExpressionDescriptor dataExpressionDescriptor) {
        if (dataExpressionDescriptor instanceof HttpRequestDataExpressionDescriptor) {
            return this.buildHttpRequestDataExpression((HttpRequestDataExpressionDescriptor)dataExpressionDescriptor);
        }
        throw new IllegalArgumentException("DataExpression not supported, this is a bug.");
    }

    public HttpRequestDataExpression buildHttpRequestDataExpression(HttpRequestDataExpressionDescriptor dataExpressionDescriptor) {
        return new HttpRequestDataExpression(dataExpressionDescriptor.getPath(), HTTPMethod.fromString(dataExpressionDescriptor.getMethod().getName()), this.buildHttpRequestBinding(dataExpressionDescriptor.getBindings()));
    }

    private HttpRequestBinding buildHttpRequestBinding(HttpRequestDataExpressionBindingDescriptor bindingDescriptor) {
        if (bindingDescriptor == null) {
            return null;
        }
        return new HttpRequestBinding(this.connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getUriParameters()), this.connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getQueryParameters()), this.connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getHeaders()));
    }
}

