/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.DataWeaveExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.Expression;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;

import java.util.List;

public class ConnectorArgumentBuilder {

  // --- Generic Connector Arguments
  public List<Argument> buildArgumentList(List<ArgumentDescriptor> argumentDescriptors) {
    return argumentDescriptors.stream().map(this::buildArgument).collect(toList());
  }

  private Argument buildArgument(ArgumentDescriptor argumentDescriptor) {
    return new Argument(argumentDescriptor.getName(),
                        buildDWExpression(argumentDescriptor.getValue()));
    //TODO RSDK-260: Always expression?
  }

  private Expression buildDWExpression(String expressionContent) {
    //TODO RSDK-260: Currently arguments are always Strings. It is inferred when these are expressions.
    return new DataWeaveExpression(expressionContent);
  }

}
