/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;

import java.util.List;

public class HttpRequestBinding {

  private final List<Argument> uriParameter;
  private final List<Argument> queryParameter;
  private final List<Argument> header;

  public HttpRequestBinding(
                            List<Argument> uriParameter,
                            List<Argument> queryParameter,
                            List<Argument> header) {
    this.uriParameter = uriParameter;
    this.queryParameter = queryParameter;
    this.header = header;
  }

  public List<Argument> getUriParameter() {
    return uriParameter;
  }

  public List<Argument> getQueryParameter() {
    return queryParameter;
  }

  public List<Argument> getHeader() {
    return header;
  }
}
