/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.DataExpression;

public class HttpRequestDataExpression extends DataExpression {

  private final String path;
  private final HTTPMethod method;
  private final HttpRequestBinding httpRequestBinding;

  public HttpRequestDataExpression(String path, HTTPMethod method, HttpRequestBinding httpRequestBinding) {
    this.path = path;
    this.method = method;
    this.httpRequestBinding = httpRequestBinding;
  }

  public String getPath() {
    return path;
  }

  public HTTPMethod getMethod() {
    return method;
  }

  public HttpRequestBinding getHttpRequestBinding() {
    return httpRequestBinding;
  }
}
