/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;

import javax.ws.rs.core.MediaType;
import java.util.List;

public class ArrayTypeDefinition extends TypeDefinition {

  private final TypeDefinition innerType;

  ArrayTypeDefinition(MediaType mediaType, String example, List<String> enumValues, TypeSchema typeSchema,
                      TypeDefinition innerType, String displayName, String description) {
    super(mediaType, example, enumValues, typeSchema, displayName, description);
    this.innerType = innerType;
  }

  public TypeDefinition getInnerType() {
    return innerType;
  }
}
