/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorSimpleDataBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataBuilderUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerWatermarkDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.simpledata.SimpleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class ConnectorTriggerBuilder {
    private final TypeSchemaPool typeSchemaPool;
    private final ConnectorSimpleDataBuilder connectorSimpleDataBuilder;

    public ConnectorTriggerBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaPool = typeSchemaPool;
        this.connectorSimpleDataBuilder = new ConnectorSimpleDataBuilder();
    }

    public List<Trigger> buildTriggers(ConnectorDescriptor connectorDescriptor, List<ConnectorOperation> operations) throws ModelGenerationException {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        if (connectorDescriptor.getTriggers() != null) {
            for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
                ConnectorOperation operation = operations.stream().filter(x -> x.getPath().equalsIgnoreCase(triggerDescriptor.getPath())).filter(x -> x.getHttpMethod().equalsIgnoreCase(triggerDescriptor.getMethod().getName())).findFirst().orElse(null);
                Objects.requireNonNull(operation);
                triggers.add(this.buildTrigger(operation, triggerDescriptor));
            }
        }
        return triggers;
    }

    public Trigger buildTrigger(ConnectorOperation operation, TriggerDescriptor triggerDescriptor) throws ModelGenerationException {
        TypeDefinition triggerOutputType = this.buildTriggerOutputType(operation, triggerDescriptor);
        return new Trigger(triggerDescriptor.getName(), triggerDescriptor.getDisplayName(), triggerDescriptor.getDescription(), triggerDescriptor.getItemsExpression(), triggerDescriptor.getIdentityExpression(), this.getRequestBodyExpression(triggerDescriptor), this.getWatermarkExpression(triggerDescriptor), this.buildWatermarkType(triggerDescriptor.getWatermark()), this.buildParameters(triggerDescriptor.getParameters()), this.buildParameterBindings(triggerDescriptor.getParameterBindings()), triggerOutputType, operation, SampleDataBuilderUtil.shouldHaveSampleData(triggerDescriptor.getSampleDataDescriptor(), operation.getHttpMethod()), this.connectorSimpleDataBuilder.buildSimpleData((ResolverExpressionDescriptor<SimpleDataDefinitionDescriptor>)triggerDescriptor.getSimpleDataExpressionDescriptor()));
    }

    private TypeDefinition buildTriggerOutputType(ConnectorOperation operation, TriggerDescriptor triggerDescriptor) throws ModelGenerationException {
        TypeDefinition triggerOutputType;
        if (StringUtils.isNotBlank((CharSequence)triggerDescriptor.getOutputTypeSchema())) {
            ConnectorTypeDefinitionBuilder typeDefinitionBuilder = new ConnectorTypeDefinitionBuilder(this.typeSchemaPool);
            MediaType triggerMediaType = StringUtils.isNotBlank((CharSequence)triggerDescriptor.getOutputMediaType()) ? MediaType.valueOf((String)triggerDescriptor.getOutputMediaType()) : operation.getOutputMetadata().getMediaType();
            triggerOutputType = typeDefinitionBuilder.buildTypeDefinition(triggerDescriptor.getOutputTypeSchema(), triggerMediaType);
        } else {
            triggerOutputType = operation.getOutputMetadata();
        }
        return triggerOutputType;
    }

    private String getWatermarkExpression(TriggerDescriptor triggerDescriptor) {
        if (triggerDescriptor == null || triggerDescriptor.getWatermark() == null) {
            return null;
        }
        return triggerDescriptor.getWatermark().getExtraction();
    }

    private String getRequestBodyExpression(TriggerDescriptor triggerDescriptor) {
        if (triggerDescriptor == null || triggerDescriptor.getParameterBindings() == null) {
            return null;
        }
        return triggerDescriptor.getParameterBindings().getRequestBodyExpression();
    }

    private ParameterDataType buildWatermarkType(TriggerWatermarkDescriptor watermarkDescriptor) {
        if (watermarkDescriptor == null || watermarkDescriptor.getDataType() == null) {
            return ParameterDataType.STRING;
        }
        return ParameterDataType.forName(watermarkDescriptor.getDataType().getName());
    }

    private List<ParameterBinding> buildParameterBindings(TriggerParameterBindingsDescriptor parameterBindings) {
        if (parameterBindings == null) {
            return null;
        }
        LinkedList<ParameterBinding> parameterBindingList = new LinkedList<ParameterBinding>();
        if (parameterBindings.getUriParameters() != null) {
            for (TriggerParameterBindingDescriptor uriParam : parameterBindings.getUriParameters()) {
                parameterBindingList.add(this.buildParameterBinding(uriParam, ParameterType.URI));
            }
        }
        if (parameterBindings.getQueryParameters() != null) {
            for (TriggerParameterBindingDescriptor queryParam : parameterBindings.getQueryParameters()) {
                parameterBindingList.add(this.buildParameterBinding(queryParam, ParameterType.QUERY));
            }
        }
        if (parameterBindings.getHeaders() != null) {
            for (TriggerParameterBindingDescriptor header : parameterBindings.getHeaders()) {
                parameterBindingList.add(this.buildParameterBinding(header, ParameterType.HEADER));
            }
        }
        return parameterBindingList;
    }

    private ParameterBinding buildParameterBinding(TriggerParameterBindingDescriptor descriptor, ParameterType parameterType) {
        return new ParameterBinding(parameterType, descriptor.getName(), descriptor.getValue());
    }

    private List<TriggerParameter> buildParameters(List<TriggerParameterDescriptor> parameterDescriptors) {
        LinkedList<TriggerParameter> parameters = new LinkedList<TriggerParameter>();
        for (TriggerParameterDescriptor parameterDescriptor : parameterDescriptors) {
            parameters.add(this.buildParameter(parameterDescriptor));
        }
        return parameters;
    }

    private TriggerParameter buildParameter(TriggerParameterDescriptor parameterDescriptor) {
        return new TriggerParameter(parameterDescriptor.getName(), parameterDescriptor.getDisplayName(), ParameterDataType.forName(parameterDescriptor.getDataType().getName()), parameterDescriptor.getDescription(), parameterDescriptor.isRequired());
    }
}

