/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BasicAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.CustomAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.DigestAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2AuthorizationCodeScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.PassThroughScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.UnsecuredScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;
import java.util.LinkedList;
import java.util.List;

public abstract class ConnectorSecurityScheme {
    protected final List<Parameter> headers = new LinkedList<Parameter>();
    protected final List<Parameter> queryParameters = new LinkedList<Parameter>();
    protected final SecuritySchemeType schemeType;
    protected final String displayName;
    protected final TestConnectionConfig testConnectionConfig;

    public ConnectorSecurityScheme(SecuritySchemeType schemeType, String displayName, TestConnectionConfig testConnectionConfig) {
        this.schemeType = schemeType;
        this.displayName = displayName;
        this.testConnectionConfig = testConnectionConfig;
    }

    public SecuritySchemeType getSchemeType() {
        return this.schemeType;
    }

    public String getDisplayName() {
        if (this.schemeType.equals((Object)SecuritySchemeType.UNSECURED)) {
            return SecuritySchemeType.UNSECURED.name();
        }
        return this.displayName;
    }

    public TestConnectionConfig getTestConnectionConfig() {
        return this.testConnectionConfig;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorSecurityScheme)) {
            return false;
        }
        ConnectorSecurityScheme that = (ConnectorSecurityScheme)o;
        return that.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return HashCodeUtil.generateHashCode(new Object[]{this.schemeType, this.headers, this.queryParameters});
    }

    public static Builder builder(String displayName, List<Parameter> customQueryParams, List<Parameter> customHeaders, TestConnectionConfig testConnectionConfig) {
        return new Builder(displayName, customQueryParams, customHeaders, testConnectionConfig);
    }

    public static class Builder {
        private final List<Parameter> customHeaders;
        private final List<Parameter> customQueryParams;
        private final String displayName;
        private final TestConnectionConfig testConnectionConfig;

        public Builder(String displayName, List<Parameter> customQueryParams, List<Parameter> customHeaders, TestConnectionConfig testConnectionConfig) {
            this.customHeaders = customHeaders;
            this.customQueryParams = customQueryParams;
            this.displayName = displayName;
            this.testConnectionConfig = testConnectionConfig;
        }

        public BasicAuthScheme buildBasicAuthScheme() {
            return new BasicAuthScheme(this.displayName, this.testConnectionConfig);
        }

        public CustomAuthenticationScheme buildCustomAuthenticationScheme() {
            return new CustomAuthenticationScheme(this.displayName, this.customQueryParams, this.customHeaders, this.testConnectionConfig);
        }

        public DigestAuthenticationScheme buildDigestAuthenticationSchemeScheme() {
            return new DigestAuthenticationScheme(this.displayName, this.testConnectionConfig);
        }

        public OAuth2AuthorizationCodeScheme buildOAuth2AuthorizationCodeScheme(String authorizationUri, String accessTokenUri, List<String> scopes) {
            return new OAuth2AuthorizationCodeScheme(this.displayName, authorizationUri, accessTokenUri, scopes, this.customQueryParams, this.customHeaders, this.testConnectionConfig);
        }

        public OAuth2ClientCredentialsScheme buildOAuth2ClientCredentialsScheme(String authorizationUri, String accessTokenUri, List<String> scopes) {
            return new OAuth2ClientCredentialsScheme(this.displayName, authorizationUri, accessTokenUri, scopes, this.customQueryParams, this.customHeaders, this.testConnectionConfig);
        }

        public PassThroughScheme buildPassThroughScheme() {
            return new PassThroughScheme(this.displayName, this.customQueryParams, this.customHeaders, this.testConnectionConfig);
        }

        public UnsecuredScheme buildUnsecuredScheme() {
            return new UnsecuredScheme(this.testConnectionConfig);
        }
    }

    public static enum SecuritySchemeType {
        BASIC("Basic Authentication"),
        OAUTH1("OAuth 1.0"),
        OAUTH2("OAuth 2.0"),
        PASS_THROUGH("Pass Through"),
        DIGEST_AUTHENTICATION("Digest Authentication"),
        CUSTOM_AUTHENTICATION("Custom Authentication"),
        UNSECURED("Unsecured"),
        NOT_SUPPORTED("Not Supported");

        private final String type;

        private SecuritySchemeType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

