/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import static org.skyscreamer.jsonassert.JSONCompare.compareJSON;
import static org.skyscreamer.jsonassert.JSONCompareMode.NON_EXTENSIBLE;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TypeSchemaPool {

  private static final ObjectMapper MAPPER = new ObjectMapper();

  private final Map<String, TypeSchema> innerJsonPool = new HashMap<>();
  private final Map<String, TypeSchema> innerSchemaPool = new HashMap<>();

  public TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
    final TypeSchema returnSchema;
    final String rawSchema = typeSchema.getRawSchema();
    final boolean isJsonSchema = isJsonSchema(rawSchema);

    if (isJsonSchema) {
      String first = innerJsonPool.keySet().stream().filter(x -> isEqualJsonSchema(x, rawSchema)).findFirst().orElse(null);
      returnSchema = innerJsonPool.get(first);
    } else {
      returnSchema = innerSchemaPool.get(rawSchema);
    }

    if (returnSchema == null) {
      return putTypeSchema(typeSchema, isJsonSchema);
    }

    return returnSchema;
  }

  private TypeSchema putTypeSchema(TypeSchema typeSchema, boolean isJsonSchema) {
    if (isJsonSchema) {
      innerJsonPool.put(typeSchema.getRawSchema(), typeSchema);
    } else {
      innerSchemaPool.put(typeSchema.getRawSchema(), typeSchema);
    }

    return typeSchema;
  }

  private boolean isJsonSchema(String rawSchema) {
    try {
      MAPPER.readTree(rawSchema);
      return true;
    } catch (IOException e) {
      return false;
    }
  }

  private boolean isEqualJsonSchema(String schemaA, String schemaB) {
    if (schemaA.equals(schemaB)) {
      return true;
    }

    return !compareJSON(schemaA, schemaB, NON_EXTENSIBLE).failed();
  }
}
