/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw;

import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

import java.net.URL;
import java.util.HashMap;

public class OperationDisplayNameExpressionHandler {

  public static final String[] IMPLICIT_INPUTS = {"operationId", "method", "path", "summary"};
  private final DataWeaveScript script;

  /**
   * @param script parameterized by the user, which might have the extra '#['/']' we need to remove
   * @throws CompilationException if the user consumes bindings that are not present, see {@link #IMPLICIT_INPUTS}
   */
  public OperationDisplayNameExpressionHandler(String script) throws CompilationException {
    DataWeaveScriptingEngine scriptingEngine = new DataWeaveScriptingEngine();
    this.script = scriptingEngine.compile(curateScript(script), IMPLICIT_INPUTS);
  }

  /**
   * Only needed when the script comes from a user
   * 
   * @param script from the user
   * @return a trimmed script without the '#['/']'
   */
  private String curateScript(String script) {
    String trimmedScript = script.trim();
    if (trimmedScript.startsWith("#[") && trimmedScript.endsWith("]")) {
      trimmedScript = trimmedScript.substring(2, trimmedScript.length() - 1);
    }
    return trimmedScript;
  }

  public OperationDisplayNameExpressionHandler() {
    DataWeaveScriptingEngine scriptingEngine = new DataWeaveScriptingEngine();
    this.script = scriptingEngine.compile(getDefaultWeaveOperationDisplayName(), IMPLICIT_INPUTS);
  }

  private static URL getDefaultWeaveOperationDisplayName() {
    String weaveScriptFile = "operationDisplayName.dwl";
    URL resource = OperationDisplayNameExpressionHandler.class.getResource(weaveScriptFile);
    if (resource == null) {
      throw new RuntimeException(String.format("Could not found DWL file '%s' in the resources, this is a bug", weaveScriptFile));
    }
    return resource;
  }

  public String evaluate(String operationId, String method, String path, String summary) {
    ScriptingBindings bindings = new ScriptingBindings();
    addBinding(bindings, "operationId", operationId);
    addBinding(bindings, "method", method);
    addBinding(bindings, "path", path);
    addBinding(bindings, "summary", summary);
    // we parameterize the outputMimeType to avoid asking each user to feed it in their scripts, we will default to
    // application/java, specially as we are going to consume the result as a string afterwards
    DataWeaveResult dataWeaveResult = script.write(bindings, ServiceManager.apply(), "application/java");
    return dataWeaveResult.getContentAsString();
  }

  private void addBinding(ScriptingBindings bindings, String name, String value) {
    bindings.addBinding(name, value, "application/java", new HashMap<>());
  }

}
