/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil.generateHashCode;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;

import java.util.List;

public class Parameter {

  /**
   * XML name used to identify this parameter internally.
   */
  private final String internalName;

  /**
   * Name used to identify this parameter externally. i.e. the name of the query parameter the API is expecting.
   */
  private final String externalName;

  /**
   * User friendly name for this parameter
   */
  private final String displayName;

  private final String description;
  private final boolean required;
  private final String defaultValue;
  private final boolean isPassword;
  private final TypeDefinition typeDefinition;
  private final ParameterType parameterType;
  private final ResolverExpression<ValueProviderDefinition> valueProvider;

  public Parameter(String displayName,
                   String externalName,
                   ParameterType parameterType,
                   TypeDefinition typeDefinition,
                   String description,
                   boolean required,
                   String defaultValue,
                   boolean password,
                   ResolverExpression<ValueProviderDefinition> valueProvider,
                   List<String> collisionInternalNames) {

    this(buildParameterInternalName(externalName, collisionInternalNames, parameterType),
         displayName,
         externalName,
         parameterType,
         typeDefinition,
         description,
         required,
         defaultValue,
         password,
         valueProvider);
  }

  protected Parameter(String internalName,
                      String displayName,
                      String externalName,
                      ParameterType parameterType,
                      TypeDefinition typeDefinition,
                      String description,
                      boolean required,
                      String defaultValue,
                      boolean password,
                      ResolverExpression<ValueProviderDefinition> valueProvider) {

    this.displayName = displayName;
    this.externalName = externalName;
    this.internalName = internalName;

    this.parameterType = parameterType;

    this.typeDefinition = typeDefinition;
    this.isPassword = password;
    this.description = description;
    this.required = required;
    this.defaultValue = defaultValue;

    this.valueProvider = valueProvider;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getExternalName() {
    return externalName;
  }

  public TypeDefinition getTypeDefinition() {
    return typeDefinition;
  }

  public String getDescription() {
    return description;
  }

  public boolean isRequired() {
    return required;
  }

  public String getDefaultValue() {
    return defaultValue;
  }

  public boolean isPassword() {
    return isPassword;
  }

  public ParameterType getParameterType() {
    return parameterType;
  }

  public ResolverExpression<ValueProviderDefinition> getValueProvider() {
    return valueProvider;
  }

  @Override
  public int hashCode() {
    return generateHashCode(internalName, displayName, description, required, defaultValue, typeDefinition,
                            isPassword);
  }

}
