/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import static java.util.regex.Pattern.compile;
import static org.apache.commons.lang.StringUtils.isBlank;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;

import java.util.List;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

public final class NamingUtil {

  private NamingUtil() {}

  private static final Pattern CHARACTER_SPLIT_PATTERN = compile("([a-zA-Z0-9])([\\-_.]+)([a-zA-Z0-9]*)");

  public static boolean isFriendlyName(String name) {
    if (isBlank(name)) {
      return false;
    }

    if (name.contains(" ")) {
      return true;
    }

    return ParserUtils.splitCaps(name, " ").equalsIgnoreCase(name)
        && !CHARACTER_SPLIT_PATTERN.matcher(name).find();
  }

  public static String makeNameFriendly(String name) {
    String friendlyName = name.trim();

    if (friendlyName.contains(" ")) {
      return friendlyName;
    }

    while (CHARACTER_SPLIT_PATTERN.matcher(friendlyName).find()) {
      friendlyName = CHARACTER_SPLIT_PATTERN.matcher(friendlyName).replaceAll("$1 $3");
    }

    friendlyName = ParserUtils.splitCaps(friendlyName, " ");

    if (friendlyName.toUpperCase().equals(friendlyName)) {
      friendlyName = friendlyName.toLowerCase();
    }

    return StringUtils.capitalize(friendlyName);
  }

  public static String buildParameterInternalName(String externalName,
                                                  List<String> collisionInternalNames,
                                                  ParameterType parameterType) {
    String name = getXmlName(externalName);

    if (collisionInternalNames != null) {
      if (nameCollides(collisionInternalNames, name)) {
        name = name + "-" + getXmlName(parameterType.getName());
      }

      if (nameCollides(collisionInternalNames, name)) {
        int parameterNumber = 2;
        String numberName = name + "-" + parameterNumber;

        while (nameCollides(collisionInternalNames, numberName)) {
          parameterNumber++;
          numberName = name + "-" + parameterNumber;
        }

        name = numberName;
      }
    }

    return name;
  }

  private static boolean nameCollides(List<String> collisionNames, String name) {
    return collisionNames.stream().anyMatch(x -> x.equalsIgnoreCase(name));
  }
}
