/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;

public class ValueProviderDefinition extends ResolverDefinition<ValueProviderDefinition> {

  private final HttpRequestDataExpression request;
  private final String itemExtractionExpression;
  private final String itemValueExpression;
  private final String itemDisplayNameExpression;

  public ValueProviderDefinition(HttpRequestDataExpression request, String itemExtractionExpression, String itemValueExpression,
                                 String itemDisplayNameExpression) {
    this.request = request;
    this.itemExtractionExpression = itemExtractionExpression;
    this.itemValueExpression = itemValueExpression;
    this.itemDisplayNameExpression = itemDisplayNameExpression;
  }

  public HttpRequestDataExpression getRequest() {
    return request;
  }

  public String getItemExtractionExpression() {
    return itemExtractionExpression;
  }

  public String getItemValueExpression() {
    return itemValueExpression;
  }

  public String getItemDisplayNameExpression() {
    return itemDisplayNameExpression;
  }
}
