/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.OperationNamingUtils.buildCanonicalOperationName;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;

import java.util.List;


public class ConnectorOperation {

  /**
   * XML name used to identify this operation internally.
   */
  private final String internalName;

  /**
   * User friendly name for this parameter
   */
  private final String displayName;

  private final String description;
  /**
   * Mapping key name defined for a multiple base path type.
   */
  private final String alternativeBaseUri;
  private final String path;
  private final HTTPMethod httpMethod;
  private final Pagination pagination;
  private final List<Parameter> uriParameters;
  private final List<Parameter> queryParameters;
  private final List<Parameter> headers;

  private final TypeDefinition inputMetadata;
  private final TypeDefinition outputMetadata;

  private final Boolean skipOutputTypeValidation;
  private final Boolean voidOperation;
  private final QueryParamArrayFormat queryParamArrayFormat;

  /**
   * This field indicates if the operation is not meant to be generated in the generated connector.
   */
  private final boolean isIgnored;

  private final List<ConnectorSecurityScheme> securitySchemes;

  private ResolverExpression<SampleDataDefinition> sampleData;

  public ConnectorOperation(String displayName,
                            String description,
                            String path,
                            HTTPMethod httpMethod,
                            List<Parameter> uriParameters,
                            List<Parameter> queryParameters,
                            List<Parameter> headers,
                            TypeDefinition inputMetadata,
                            TypeDefinition outputMetadata,
                            List<ConnectorSecurityScheme> securitySchemes,
                            String alternativeBaseUri,
                            Pagination pagination,
                            Boolean skipOutputTypeValidation,
                            Boolean voidOperation,
                            QueryParamArrayFormat queryParamArrayFormat,
                            boolean isIgnored) {

    final String identifier = buildCanonicalOperationName(httpMethod, path);
    this.internalName = getXmlName(identifier);
    this.displayName = displayName;
    this.description = description;
    this.path = path;
    this.httpMethod = httpMethod;

    this.uriParameters = uriParameters;
    this.queryParameters = queryParameters;
    this.headers = headers;
    this.inputMetadata = inputMetadata;
    this.outputMetadata = outputMetadata;
    this.securitySchemes = securitySchemes;

    this.alternativeBaseUri = alternativeBaseUri;
    this.pagination = pagination;

    this.skipOutputTypeValidation = skipOutputTypeValidation;
    this.voidOperation = voidOperation;
    this.queryParamArrayFormat = queryParamArrayFormat;

    this.isIgnored = isIgnored;
  }

  public List<Parameter> getQueryParameters() {
    return queryParameters;
  }

  public List<Parameter> getUriParameters() {
    return uriParameters;
  }

  public List<Parameter> getHeaders() {
    return headers;
  }

  public String getHttpMethod() {
    return httpMethod.toString().toLowerCase();
  }

  public String getPath() {
    return path;
  }

  public String getDescription() {
    return description;
  }

  public TypeDefinition getInputMetadata() {
    return inputMetadata;
  }

  public TypeDefinition getOutputMetadata() {
    return outputMetadata;
  }

  public List<ConnectorSecurityScheme> getSecuritySchemes() {
    return securitySchemes;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getAlternativeBaseUri() {
    return alternativeBaseUri;
  }

  public Pagination getPagination() {
    return pagination;
  }

  public boolean hasPagination() {
    return this.pagination != null;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public Boolean getVoidOperation() {
    return voidOperation;
  }

  public QueryParamArrayFormat getQueryParamArrayFormat() {
    return queryParamArrayFormat;
  }

  public boolean isIgnored() {
    return isIgnored;
  }

  public ResolverExpression<SampleDataDefinition> getSampleData() {
    return sampleData;
  }

  public void setSampleData(ResolverExpression<SampleDataDefinition> sampleData) {
    this.sampleData = sampleData;
  }
}
