/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.DataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.DataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionDescriptor;

public class ConnectorDataExpressionBuilder {

  private final ConnectorArgumentBuilder connectorArgumentBuilder = new ConnectorArgumentBuilder();

  // --- Generic Data Expressions
  public DataExpression buildDataExpression(DataExpressionDescriptor dataExpressionDescriptor) {
    if (dataExpressionDescriptor instanceof HttpRequestDataExpressionDescriptor) {
      return buildHttpRequestDataExpression((HttpRequestDataExpressionDescriptor) dataExpressionDescriptor);
    }

    throw new IllegalArgumentException("DataExpression not supported, this is a bug.");
  }

  // --- Http Request Data Expression
  public HttpRequestDataExpression buildHttpRequestDataExpression(HttpRequestDataExpressionDescriptor dataExpressionDescriptor) {
    return new HttpRequestDataExpression(dataExpressionDescriptor.getPath(),
                                         HTTPMethod.fromString(dataExpressionDescriptor.getMethod().getName()),
                                         buildHttpRequestBinding(dataExpressionDescriptor.getBindings()));
  }

  private HttpRequestBinding buildHttpRequestBinding(HttpRequestDataExpressionBindingDescriptor bindingDescriptor) {
    if (bindingDescriptor == null) {
      return null;
    }

    return new HttpRequestBinding(
                                  connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getUriParameters()),
                                  connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getQueryParameters()),
                                  connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getHeaders()));
  }
}
