/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorDataExpressionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;

public class ConnectorValueProviderBuilder {

  private final ConnectorResolverBuilder connectorResolverBuilder = new ConnectorResolverBuilder();
  private final ConnectorDataExpressionBuilder connectorDataExpressionBuilder = new ConnectorDataExpressionBuilder();

  public ResolverExpression<ValueProviderDefinition> buildValueProvider(ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor> resolverExpressionDescriptor) {
    if (resolverExpressionDescriptor == null) {
      return null;
    }

    if (resolverExpressionDescriptor instanceof ResolverDefinitionDescriptor) {
      return buildValueProviderDefinition((ValueProviderDefinitionDescriptor) resolverExpressionDescriptor);

    } else if (resolverExpressionDescriptor instanceof ResolverReferenceDescriptor) {
      ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> resolverReference =
          (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>) resolverExpressionDescriptor;

      return connectorResolverBuilder
          .buildResolverReference(resolverReference,
                                  buildValueProviderDefinition(resolverReference.getDeclaration().getDefinition()));

    }

    throw new IllegalArgumentException("ResolverExpressionDescriptor not supported, this is a bug.");
  }

  private ValueProviderDefinition buildValueProviderDefinition(ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor) {
    return new ValueProviderDefinition(
                                       connectorDataExpressionBuilder
                                           .buildHttpRequestDataExpression(valueProviderDefinitionDescriptor.getRequest()),
                                       valueProviderDefinitionDescriptor.getItemsExtractionExpression(),
                                       valueProviderDefinitionDescriptor.getItemValueExpression(),
                                       valueProviderDefinitionDescriptor.getItemDisplayNameExpression());
  }
}
