/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;

import java.util.List;

public class ResolverReference<T extends ResolverDefinition<T>> implements ResolverExpression<T> {

  private final ResolverDeclaration<T> declaration;
  private final List<Argument> arguments;

  public ResolverReference(
                           ResolverDeclaration<T> declaration,
                           List<Argument> arguments) {
    this.declaration = declaration;
    this.arguments = arguments;
  }

  public ResolverDeclaration<T> getDeclaration() {
    return declaration;
  }

  public List<Argument> getArguments() {
    return arguments;
  }
}
