/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema;

import static org.apache.commons.lang.StringUtils.isNotBlank;

import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;

import java.io.File;
import java.io.StringReader;
import java.util.function.Supplier;

public class XmlTypeSchema extends TypeSchema {

  private String elementName;
  private String schemaPath;

  public XmlTypeSchema(Supplier<String> rawSchemaSupplier) {
    super(rawSchemaSupplier);
  }

  public XmlTypeSchema(String rawSchema) {
    super(rawSchema);
  }

  public XmlTypeSchema(String rawSchema, String elementName, String schemaPath) {
    super(rawSchema);
    this.elementName = elementName;
    this.schemaPath = schemaPath;
  }

  public String getSchemaPath() {
    return schemaPath;
  }

  public String getElementName() {
    if (elementName == null) {
      elementName = getDefaultElementName();
    }

    return elementName;
  }

  private String getDefaultElementName() {
    final XmlSchemaCollection schemaCol = new XmlSchemaCollection();

    if (isNotBlank(schemaPath)) {
      schemaCol.setBaseUri(new File(schemaPath).toPath().getParent().toString());
    }

    final XmlSchema schema = schemaCol.read(new StringReader(getRawSchema()));

    return schema.getElements().keySet().isEmpty() ? null : schema.getElements().keySet().toArray()[0].toString();
  }
}
