/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ConnectorValueProviderBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class ConnectorParameterBuilder {
    private final ConnectorTypeDefinitionBuilder typeDefinitionBuilder;
    private final ConnectorValueProviderBuilder connectorValueProviderBuilder = new ConnectorValueProviderBuilder();

    public ConnectorParameterBuilder(ConnectorTypeDefinitionBuilder connectorTypeDefinitionBuilder) {
        this.typeDefinitionBuilder = connectorTypeDefinitionBuilder;
    }

    public List<Parameter> buildParameterList(List<APIParameterModel> parametersModel, OperationDescriptor operationDescriptor, List<String> parameterCollisionInternalNames) throws ModelGenerationException {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        LinkedList<String> collisionNames = new LinkedList<String>(parameterCollisionInternalNames);
        for (APIParameterModel parameterModel : parametersModel) {
            ParameterDescriptor parameterDescriptor = ConnectorParameterBuilder.getParameterDescriptor(parameterModel, operationDescriptor);
            if (parameterDescriptor != null && parameterDescriptor.isIgnored()) continue;
            Parameter parameter = this.buildParameter(parameterModel, parameterDescriptor, collisionNames);
            parameterList.add(parameter);
            collisionNames.add(parameter.getInternalName());
        }
        return parameterList;
    }

    public List<Parameter> buildParameterList(List<APIParameterModel> parametersModel, SecuritySchemeDescriptor securitySchemeDescriptor, List<String> parameterCollisionInternalNames) throws ModelGenerationException {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        LinkedList<String> collisionNames = new LinkedList<String>(parameterCollisionInternalNames);
        for (APIParameterModel parameterModel : parametersModel) {
            ParameterDescriptor parameterDescriptor = ConnectorParameterBuilder.getParameterDescriptor(parameterModel, securitySchemeDescriptor);
            if (parameterDescriptor != null && parameterDescriptor.isIgnored()) continue;
            Parameter parameter = this.buildParameter(parameterModel, parameterDescriptor, collisionNames);
            parameterList.add(parameter);
            collisionNames.add(parameter.getInternalName());
        }
        return parameterList;
    }

    private static ParameterDescriptor getParameterDescriptor(APIParameterModel parameterModel, SecuritySchemeDescriptor securitySchemeDescriptor) {
        if (securitySchemeDescriptor == null) {
            return null;
        }
        List parameterDescriptors = new LinkedList();
        if (securitySchemeDescriptor.getHeaders() != null) {
            if (parameterModel.getParameterType().equals((Object)APIParameterType.HEADER)) {
                parameterDescriptors = securitySchemeDescriptor.getHeaders();
            }
            if (parameterModel.getParameterType().equals((Object)APIParameterType.QUERY)) {
                parameterDescriptors = securitySchemeDescriptor.getQueryParameters();
            }
        }
        return parameterDescriptors.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getParamName())).filter(x -> x.getParamName().equalsIgnoreCase(parameterModel.getExternalName())).findFirst().orElse(null);
    }

    private static ParameterDescriptor getParameterDescriptor(APIParameterModel parameterModel, OperationDescriptor operationDescriptor) {
        if (operationDescriptor == null) {
            return null;
        }
        List parameterDescriptors = new LinkedList();
        if (operationDescriptor.getExpects() != null) {
            if (parameterModel.getParameterType().equals((Object)APIParameterType.URI)) {
                parameterDescriptors = operationDescriptor.getExpects().getUriParameter();
            } else if (parameterModel.getParameterType().equals((Object)APIParameterType.QUERY)) {
                parameterDescriptors = operationDescriptor.getExpects().getQueryParameter();
            } else if (parameterModel.getParameterType().equals((Object)APIParameterType.HEADER)) {
                parameterDescriptors = operationDescriptor.getExpects().getHeader();
            }
        }
        return parameterDescriptors.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getParamName())).filter(x -> x.getParamName().equalsIgnoreCase(parameterModel.getExternalName())).findFirst().orElse(null);
    }

    public Parameter buildParameter(APIParameterModel apiParameterModel, ParameterDescriptor parameterDescriptor, List<String> collisionInternalNames) throws ModelGenerationException {
        return new Parameter(ConnectorParameterBuilder.buildDisplayName(apiParameterModel, parameterDescriptor), apiParameterModel.getExternalName(), this.buildParameterType(apiParameterModel.getParameterType()), this.buildParameterTypeDefinition(apiParameterModel.getTypeModel(), null), ConnectorParameterBuilder.buildDescription(apiParameterModel, parameterDescriptor), apiParameterModel.isRequired(), apiParameterModel.getDefaultValue(), apiParameterModel.isPassword(), this.buildValueProvider(parameterDescriptor), collisionInternalNames);
    }

    private ResolverExpression<ValueProviderDefinition> buildValueProvider(ParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            return null;
        }
        return this.connectorValueProviderBuilder.buildValueProvider((ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>)parameterDescriptor.getValueProvider());
    }

    private ParameterType buildParameterType(APIParameterType parameterType) {
        switch (parameterType) {
            case URI: {
                return ParameterType.URI;
            }
            case QUERY: {
                return ParameterType.QUERY;
            }
            case HEADER: {
                return ParameterType.HEADER;
            }
            case SECURITY: {
                return ParameterType.SECURITY;
            }
            case PART: {
                return ParameterType.PART;
            }
        }
        throw new IllegalArgumentException("Parameter type not supported. Should not reach here.");
    }

    private static String buildDisplayName(APIParameterModel apiParameterModel, ParameterDescriptor parameterDescriptor) {
        String displayName = parameterDescriptor != null && StringUtils.isNotBlank((CharSequence)parameterDescriptor.getFriendlyName()) ? parameterDescriptor.getFriendlyName() : apiParameterModel.getDisplayName();
        if (!NamingUtil.isFriendlyName(displayName)) {
            displayName = NamingUtil.makeNameFriendly(displayName);
        }
        return displayName;
    }

    private static String buildDescription(APIParameterModel apiParameterModel, ParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor != null && StringUtils.isNotBlank((CharSequence)parameterDescriptor.getDescription())) {
            return parameterDescriptor.getDescription();
        }
        return apiParameterModel.getDescription();
    }

    private TypeDefinition buildParameterTypeDefinition(APITypeModel typeModel, @Nullable MediaType mediaType) throws ModelGenerationException {
        if (mediaType == null) {
            mediaType = typeModel.getMediaType() != null ? typeModel.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
        }
        return this.typeDefinitionBuilder.buildTypeDefinition(typeModel, null, mediaType);
    }

    public PartParameter buildPartParameter(APIParameterModel apiParameterModel, @Nullable PartDescriptor partDescriptor) throws ModelGenerationException {
        MediaType mediaType = null;
        if (partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getContentType())) {
            mediaType = MediaType.valueOf((String)partDescriptor.getContentType());
        }
        TypeDefinition partTypeDefinition = partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getInputType()) ? this.typeDefinitionBuilder.buildTypeDefinition(partDescriptor.getInputType(), mediaType) : this.buildParameterTypeDefinition(apiParameterModel.getTypeModel(), mediaType);
        return new PartParameter(partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getFriendlyName()) ? partDescriptor.getFriendlyName() : apiParameterModel.getDisplayName(), apiParameterModel.getExternalName(), partTypeDefinition, partDescriptor != null && StringUtils.isNotBlank((CharSequence)partDescriptor.getDescription()) ? partDescriptor.getDescription() : apiParameterModel.getDescription(), partDescriptor != null && partDescriptor.isFilePart());
    }
}

