/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol.HTTP;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol.HTTPS;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;

import java.util.List;

public class ConnectorModel {

  private final String connectorName;
  private final String connectorXmlName;
  private final List<Protocol> protocols;
  private final List<Pagination> paginations;

  private final String description;
  private final BaseUri baseUri;
  private final ConnectorCategory category;
  private final List<ConnectorOperation> operations;

  private final String mvnGroupId;
  private final String mvnArtifactId;
  private final String mvnVersion;
  private final String basePackage;
  private final String extensionXml;
  private final Boolean skipOutputTypeValidation;
  private final QueryParamArrayFormat queryParamArrayFormat;
  private final List<Trigger> triggers;

  public ConnectorModel(String connectorName,
                        String description,
                        String mvnGroupId,
                        String mvnArtifactId,
                        String mvnVersion,
                        String basePackage,
                        ConnectorCategory category,
                        BaseUri baseUri,
                        List<Protocol> protocols,
                        List<ConnectorOperation> operations,
                        List<Pagination> paginations,
                        String extensionXml,
                        Boolean skipOutputTypeValidation,
                        QueryParamArrayFormat queryParamArrayFormat,
                        List<Trigger> triggers) {

    this.connectorName = connectorName;
    this.connectorXmlName = getXmlName(connectorName);

    this.protocols = protocols;
    this.description = description;
    this.mvnGroupId = mvnGroupId;
    this.mvnArtifactId = mvnArtifactId;
    this.mvnVersion = mvnVersion;
    this.basePackage = basePackage;
    this.category = category;
    this.baseUri = baseUri;
    this.operations = operations;
    this.extensionXml = extensionXml;
    this.skipOutputTypeValidation = skipOutputTypeValidation;
    this.paginations = paginations;
    this.queryParamArrayFormat = queryParamArrayFormat;
    this.triggers = triggers;
  }

  public String getConnectorName() {
    return connectorName;
  }

  public List<ConnectorOperation> getOperations() {
    return operations;
  }

  public String getMvnGroupId() {
    return mvnGroupId;
  }

  public String getMvnArtifactId() {
    return mvnArtifactId;
  }

  public String getMvnVersion() {
    return mvnVersion;
  }

  public String getBasePackage() {
    return basePackage;
  }

  public ConnectorCategory getCategory() {
    return category;
  }

  public BaseUri getBaseUri() {
    return baseUri;
  }

  public String getConnectorXmlName() {
    return connectorXmlName;
  }

  public String getApiDescription() {
    return description;
  }

  public List<Pagination> getPaginations() {
    return paginations;
  }

  public Pagination getPagination(String pagingName) {
    return paginations.stream().filter(x -> x.getName().equals(pagingName)).findFirst().orElse(null);
  }

  public boolean supportsHTTP() {
    return protocols.contains(HTTP);
  }

  public boolean supportsHTTPS() {
    return protocols.contains(HTTPS);
  }

  public String getExtensionXml() {
    return extensionXml;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }

  public QueryParamArrayFormat getQueryParamArrayFormat() {
    return queryParamArrayFormat;
  }

  public List<Trigger> getTriggers() {
    return triggers;
  }

}
