/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static org.apache.commons.lang.StringUtils.isNotBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.isXmlSchema;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.CustomTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIJsonTypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIXmlTypeSchemaModel;

public class ConnectorTypeSchemaBuilder {

  private final TypeSchemaPool typeSchemaPool;

  public ConnectorTypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
    this.typeSchemaPool = typeSchemaPool;
  }

  public TypeSchema buildTypeSchema(APITypeSchemaModel apiTypeSchemaModel) {
    if (apiTypeSchemaModel == null) {
      return null;
    }

    TypeSchema typeSchema;
    if (apiTypeSchemaModel instanceof APIXmlTypeSchemaModel) {
      APIXmlTypeSchemaModel apiXmlSchema = (APIXmlTypeSchemaModel) apiTypeSchemaModel;
      typeSchema =
          new XmlTypeSchema(apiXmlSchema.getSchemaSupplier().get(), apiXmlSchema.getElementName(), apiXmlSchema.getPath());
    } else if (apiTypeSchemaModel instanceof APIJsonTypeSchemaModel) {
      APIJsonTypeSchemaModel apiXmlSchema = (APIJsonTypeSchemaModel) apiTypeSchemaModel;
      typeSchema = new JsonTypeSchema(apiXmlSchema.getSchemaSupplier());
    } else {
      typeSchema = new CustomTypeSchema(apiTypeSchemaModel.getSchemaSupplier(), apiTypeSchemaModel.getMediaType());
    }

    return getUniqueTypeSchema(typeSchema);
  }

  public TypeSchema buildTypeSchema(String rawSchema) {
    if (isXmlSchema(rawSchema)) {
      return getUniqueTypeSchema(new XmlTypeSchema(rawSchema));
    } else {
      return getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }
  }

  private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
    if (typeSchema != null && isNotBlank(typeSchema.getRawSchema())) {
      return typeSchemaPool.getUniqueTypeSchema(typeSchema);
    }

    return typeSchema;
  }
}
