/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.Expression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.LiteralExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;

import java.util.List;

public class ConnectorResolverBuilder {


  // --- Generic Resolver Parameterization
  public <T extends ResolverDefinition<T>> ResolverReference<T> buildResolverReference(ResolverReferenceDescriptor<?> resolverReferenceDescriptor,
                                                                                       T definition) {

    final List<Argument> resolverArguments =
        resolverReferenceDescriptor.getArguments().stream()
            .map(x -> new Argument(x.getName(), buildLiteralExpression(x.getValue())))
            .collect(toList());

    return new ResolverReference<>(buildResolverDeclaration(resolverReferenceDescriptor.getDeclaration(), definition),
                                   resolverArguments);
  }

  public <T extends ResolverDefinition<T>> ResolverDeclaration<T> buildResolverDeclaration(ResolverDeclarationDescriptor<?> resolverDeclarationDescriptor,
                                                                                           T definition) {
    final List<ResolverParameter> parameters =
        resolverDeclarationDescriptor.getParameters().stream()
            .map(this::buildResolverParameter)
            .collect(toList());

    return new ResolverDeclaration<>(resolverDeclarationDescriptor.getName(), definition, parameters);
  }

  // --- Generic Resolver
  private ResolverParameter buildResolverParameter(ResolverParameterDescriptor resolverParameterDescriptor) {
    return new ResolverParameter(resolverParameterDescriptor.getName(),
                                 ParameterDataType.forName(resolverParameterDescriptor.getDataType().getName()));
  }

  // --- Expressions
  private Expression buildLiteralExpression(String expressionContent) {
    // TODO RSDK-260: Currently arguments are always Strings. Is this ok?
    return new LiteralExpression(expressionContent);
  }
}
