/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static org.apache.commons.lang3.StringUtils.EMPTY;

public enum ParameterType {

  URI("uriParam", "uriParameter"), QUERY("queryParam", "queryParameter"), HEADER("header", "header"), PART("part",
      EMPTY), SECURITY("security", EMPTY), TRIGGER("trigger", "parameter");

  private final String name;
  private final String accessorName;

  ParameterType(String shortName, String accessorName) {
    this.name = shortName;
    this.accessorName = accessorName;
  }

  public String getName() {
    return name;
  }

  public String getAccessorName() {
    return accessorName;
  }
}
