/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;

import java.util.Collections;

public class TriggerParameter {

  private final String externalName;
  private final String internalName;
  private final String displayName;
  private final ParameterDataType parameterDataType;
  private final String description;
  private final boolean required;

  public TriggerParameter(String externalName, String displayName,
                          ParameterDataType parameterDataType, String description, boolean required) {
    this.externalName = externalName;
    this.internalName =
        buildParameterInternalName(externalName, Collections.emptyList(), ParameterType.TRIGGER);

    this.parameterDataType = parameterDataType;
    this.displayName = displayName;
    this.description = description;
    this.required = required;
  }

  public String getExternalName() {
    return externalName;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getDisplayName() {
    return displayName;
  }

  public ParameterDataType getParameterType() {
    return parameterDataType;
  }

  public String getDescription() {
    return description;
  }

  public boolean isRequired() {
    return required;
  }
}
