/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorSecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.ConnectorSampleDataBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationDisplayNameExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class ConnectorOperationBuilder {
    private final ConnectorTypeDefinitionBuilder typeDefinitionBuilder;
    private final ConnectorParameterBuilder parameterBuilder;
    private final ConnectorSecuritySchemeBuilder securitySchemeBuilder;
    private final ConnectorSampleDataBuilder sampleDataBuilder;

    public ConnectorOperationBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeDefinitionBuilder = new ConnectorTypeDefinitionBuilder(typeSchemaPool);
        this.parameterBuilder = new ConnectorParameterBuilder(this.typeDefinitionBuilder);
        this.securitySchemeBuilder = new ConnectorSecuritySchemeBuilder(this.typeDefinitionBuilder);
        this.sampleDataBuilder = new ConnectorSampleDataBuilder();
    }

    public List<ConnectorOperation> buildOperations(APIModel apiModel, ConnectorDescriptor connectorDescriptor, List<Pagination> paginations, OperationIdentifierExpressionHandler operationIdentifierExpressionHandler, OperationDisplayNameExpressionHandler operationDisplayNameExpressionHandler) throws ModelGenerationException {
        ArrayList<ConnectorOperation> operations = new ArrayList<ConnectorOperation>();
        for (APIOperationModel op : apiModel.getOperationsModel()) {
            operations.add(this.buildOperation(op, ConnectorOperationBuilder.getEndpointDescriptor(op, connectorDescriptor), ConnectorOperationBuilder.getOperationDescriptor(op, connectorDescriptor), connectorDescriptor, paginations, operationIdentifierExpressionHandler, operationDisplayNameExpressionHandler));
        }
        return operations;
    }

    private static EndPointDescriptor getEndpointDescriptor(APIOperationModel operationModel, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(operationModel.getPath())).findFirst().orElse(null);
    }

    private static OperationDescriptor getOperationDescriptor(APIOperationModel operationModel, ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(operationModel.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(operationModel.getHttpMethod())).findFirst().orElse(null);
    }

    public ConnectorOperation buildOperation(APIOperationModel apiOperationModel, EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor, List<Pagination> paginations, OperationIdentifierExpressionHandler operationIdentifierExpressionHandler, OperationDisplayNameExpressionHandler operationDisplayNameExpressionHandler) throws ModelGenerationException {
        List<Parameter> uriParameters = this.parameterBuilder.buildParameterList((List<APIParameterModel>)apiOperationModel.getUriParamsModel(), operationDescriptor);
        List<Parameter> queryParameters = this.parameterBuilder.buildParameterList((List<APIParameterModel>)apiOperationModel.getQueryParamsModel(), operationDescriptor);
        List<Parameter> headers = this.parameterBuilder.buildParameterList((List<APIParameterModel>)apiOperationModel.getHeadersModel(), operationDescriptor);
        TypeDefinition outputTypeMetadata = this.buildOutputTypeMetadata(apiOperationModel, operationDescriptor, connectorDescriptor);
        if (outputTypeMetadata != null && outputTypeMetadata.getMediaType() != null) {
            headers.stream().filter(x -> x.getExternalName().equalsIgnoreCase("accept")).findFirst().ifPresent(headers::remove);
        }
        HTTPMethod method = HTTPMethod.fromString(apiOperationModel.getHttpMethod());
        ConnectorOperation operation = new ConnectorOperation(this.buildOperationIdentifier(apiOperationModel, operationIdentifierExpressionHandler), ConnectorOperationBuilder.buildOperationName(apiOperationModel, operationDescriptor, method, operationDisplayNameExpressionHandler), ConnectorOperationBuilder.buildOperationDescription(apiOperationModel, operationDescriptor), apiOperationModel.getPath(), method, uriParameters, queryParameters, headers, this.buildInputTypeMetadata(apiOperationModel, operationDescriptor, connectorDescriptor), outputTypeMetadata, this.securitySchemeBuilder.buildSecuritySchemes(apiOperationModel.getSecuritySchemesModel(), connectorDescriptor), ConnectorOperationBuilder.buildAlternativeBaseUri(endPointDescriptor, operationDescriptor), ConnectorOperationBuilder.buildPagination(operationDescriptor, paginations), ConnectorOperationBuilder.buildSkipOutputTypeValidation(operationDescriptor), ConnectorOperationBuilder.buildVoidOperation(operationDescriptor), this.buildQueryParamArrayFormat(connectorDescriptor, operationDescriptor), this.isOperationIgnoredInDescriptor(endPointDescriptor, operationDescriptor));
        operation.setSampleData(this.sampleDataBuilder.buildSampleData(this.getSampleDataExpressionDescriptor(operationDescriptor), operation, null));
        return operation;
    }

    private ResolverExpressionDescriptor<SampleDataDefinitionDescriptor> getSampleDataExpressionDescriptor(OperationDescriptor operationDescriptor) {
        return operationDescriptor != null ? operationDescriptor.getSampleDataExpressionDescriptor() : null;
    }

    private boolean isOperationIgnoredInDescriptor(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor) {
        boolean ignoredEndpoint = endPointDescriptor != null && endPointDescriptor.isIgnored() != null && endPointDescriptor.isIgnored() != false;
        Boolean ignoredOperation = operationDescriptor != null ? operationDescriptor.isIgnored() : null;
        return ignoredOperation != null && ignoredOperation != false || ignoredOperation == null && ignoredEndpoint;
    }

    protected QueryParamArrayFormat buildQueryParamArrayFormat(ConnectorDescriptor connectorDescriptor, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(operationDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(connectorDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        return QueryParamArrayFormat.MULTIMAP;
    }

    private static Boolean buildSkipOutputTypeValidation(OperationDescriptor operationDescriptor) {
        return operationDescriptor != null ? operationDescriptor.getSkipOutputTypeValidation() : null;
    }

    private static Boolean buildVoidOperation(OperationDescriptor operationDescriptor) {
        return operationDescriptor != null ? operationDescriptor.getVoidOperation() : null;
    }

    private String buildOperationIdentifier(APIOperationModel apiOperationModel, OperationIdentifierExpressionHandler operationIdentifierExpressionHandler) {
        return operationIdentifierExpressionHandler.evaluate(apiOperationModel.getOperationId(), apiOperationModel.getHttpMethod(), apiOperationModel.getPath());
    }

    private static String buildOperationName(APIOperationModel operationModel, OperationDescriptor operationDescriptor, HTTPMethod method, OperationDisplayNameExpressionHandler operationDisplayNameExpressionHandler) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getDisplayName())) {
            return operationDescriptor.getDisplayName();
        }
        return operationDisplayNameExpressionHandler.evaluate(operationModel.getOperationId(), method.name(), operationModel.getPath(), operationModel.getSummary());
    }

    private static String buildOperationDescription(APIOperationModel operationModel, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getDescription())) {
            return operationDescriptor.getDescription();
        }
        return operationModel.getDescription();
    }

    private static String buildAlternativeBaseUri(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getBaseUri())) {
            return operationDescriptor.getBaseUri();
        }
        if (endPointDescriptor != null && StringUtils.isNotBlank((CharSequence)endPointDescriptor.getBaseUri())) {
            return endPointDescriptor.getBaseUri();
        }
        return null;
    }

    private static Pagination buildPagination(OperationDescriptor operationDescriptor, List<Pagination> paginations) {
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination())) {
            return paginations.stream().filter(x -> x.getName().equals(operationDescriptor.getPagination())).findFirst().orElse(null);
        }
        return null;
    }

    private TypeDefinition buildInputTypeMetadata(APIOperationModel apiOperationModel, OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        String descriptorInputMediaType = "";
        String descriptorInputTypeSchema = "";
        List partDescriptors = null;
        if (operationDescriptor != null) {
            descriptorInputMediaType = operationDescriptor.getInputMediaType();
            descriptorInputTypeSchema = operationDescriptor.getInputTypeSchema();
            partDescriptors = operationDescriptor.getExpects() != null ? operationDescriptor.getExpects().getPart() : null;
        }
        return this.buildIOTypeMetadata(apiOperationModel.getInputMetadataModel(), connectorDescriptor.getDefaultInputMediaType(), descriptorInputMediaType, descriptorInputTypeSchema, partDescriptors);
    }

    private TypeDefinition buildOutputTypeMetadata(APIOperationModel apiOperationModel, OperationDescriptor operationDescriptor, ConnectorDescriptor connectorDescriptor) throws ModelGenerationException {
        String descriptorOutputMediaType = "";
        String descriptorOutputTypeSchema = "";
        if (operationDescriptor != null) {
            descriptorOutputMediaType = operationDescriptor.getOutputMediaType();
            descriptorOutputTypeSchema = operationDescriptor.getOutputTypeSchema();
        }
        return this.buildIOTypeMetadata(apiOperationModel.getOutputMetadataModel(), connectorDescriptor.getDefaultOutputMediaType(), descriptorOutputMediaType, descriptorOutputTypeSchema, null);
    }

    private TypeDefinition buildIOTypeMetadata(List<APITypeModel> metadataModels, String descriptorGlobalMediaType, String descriptorMediaType, String descriptorTypeSchema, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        MediaType inputMediaType = null;
        if (StringUtils.isNotBlank((CharSequence)descriptorMediaType)) {
            inputMediaType = MediaType.valueOf((String)descriptorMediaType);
        } else if (StringUtils.isNotBlank((CharSequence)descriptorGlobalMediaType)) {
            inputMediaType = MediaType.valueOf((String)descriptorGlobalMediaType);
        }
        if (StringUtils.isNotBlank((CharSequence)descriptorTypeSchema)) {
            if (inputMediaType == null) {
                APITypeModel defaultApiTypeModel = ConnectorOperationBuilder.getDefaultApiTypeModel(metadataModels);
                inputMediaType = defaultApiTypeModel.getMediaType();
            }
            return this.typeDefinitionBuilder.buildTypeDefinition(descriptorTypeSchema, inputMediaType);
        }
        return this.buildTypeMetadata(metadataModels, inputMediaType, partDescriptors);
    }

    private TypeDefinition buildTypeMetadata(List<APITypeModel> metadataModels, MediaType mediaType, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        if (!metadataModels.isEmpty()) {
            boolean metadataModelsDefineMediaType = metadataModels.stream().anyMatch(x -> x.getMediaType() != null);
            if (metadataModelsDefineMediaType) {
                APITypeModel apiTypeModel = ConnectorOperationBuilder.getDefaultApiTypeModel(metadataModels);
                if (mediaType != null && (apiTypeModel = ConnectorOperationBuilder.getApiTypeModelByMediaType(metadataModels, mediaType)) == null) {
                    throw new ModelGenerationException("Could not get body with media type from api spec: " + mediaType);
                }
                return this.typeDefinitionBuilder.buildTypeDefinition(apiTypeModel, partDescriptors);
            }
            APITypeModel apiTypeModel = ConnectorOperationBuilder.getDefaultApiTypeModel(metadataModels);
            return this.typeDefinitionBuilder.buildTypeDefinition(apiTypeModel, partDescriptors, mediaType);
        }
        return null;
    }

    private static APITypeModel getDefaultApiTypeModel(List<APITypeModel> metadataModels) {
        APITypeModel apiTypeModel = ConnectorOperationBuilder.getApiTypeModelByMediaType(metadataModels, MediaType.APPLICATION_JSON_TYPE);
        if (apiTypeModel == null) {
            apiTypeModel = ConnectorOperationBuilder.getApiTypeModelByMediaType(metadataModels, MediaType.APPLICATION_XML_TYPE);
        }
        return apiTypeModel == null ? metadataModels.get(0) : apiTypeModel;
    }

    private static APITypeModel getApiTypeModelByMediaType(List<APITypeModel> metadataModels, MediaType mediaType) {
        return metadataModels.stream().filter(x -> x.getMediaType() != null && x.getMediaType().equals((Object)mediaType)).findFirst().orElse(null);
    }
}

