/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorTypeSchemaBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveTypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang.StringUtils;

public class ConnectorTypeDefinitionBuilder {
    private final ConnectorTypeSchemaBuilder typeSchemaBuilder;
    private final ConnectorParameterBuilder parameterBuilder;

    public ConnectorTypeDefinitionBuilder(TypeSchemaPool typeSchemaPool) {
        this.typeSchemaBuilder = new ConnectorTypeSchemaBuilder(typeSchemaPool);
        this.parameterBuilder = new ConnectorParameterBuilder(this);
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel, List<PartDescriptor> partDescriptors) throws ModelGenerationException {
        return this.buildTypeDefinition(apiTypeModel, partDescriptors, apiTypeModel.getMediaType());
    }

    public TypeDefinition buildTypeDefinition(APITypeModel apiTypeModel, List<PartDescriptor> partDescriptors, MediaType mediaType) throws ModelGenerationException {
        APIType apiType;
        TypeDefinition.Builder typeDefinitionBuilder = TypeDefinition.builder(mediaType, this.typeSchemaBuilder.buildTypeSchema(apiTypeModel.getAPITypeSchemaModel()), apiTypeModel.getEnumValues(), apiTypeModel.getExample());
        if (StringUtils.isNotBlank((String)apiTypeModel.getDisplayName())) {
            typeDefinitionBuilder.withDisplayName(apiTypeModel.getDisplayName());
        }
        if (StringUtils.isNotBlank((String)apiTypeModel.getDescription())) {
            typeDefinitionBuilder.withDescription(apiTypeModel.getDescription());
        }
        if ((apiType = apiTypeModel.getApiType()) == null) {
            return null;
        }
        switch (apiType) {
            case EMPTY: {
                return typeDefinitionBuilder.buildEmptyTypeDefinition();
            }
            case PRIMITIVE: {
                return typeDefinitionBuilder.buildPrimitiveTypeDefinition(this.buildPrimitiveType(apiTypeModel.getPrimitiveTypeModel()));
            }
            case OBJECT_TYPE: {
                return typeDefinitionBuilder.buildObjectTypeDefinition();
            }
            case ARRAY: {
                MediaType innerMediaType = apiTypeModel.getInnerType().getMediaType() != null ? apiTypeModel.getInnerType().getMediaType() : mediaType;
                return typeDefinitionBuilder.buildArrayType(this.buildTypeDefinition(apiTypeModel.getInnerType(), null, innerMediaType));
            }
            case UNION_TYPE: {
                ArrayList<TypeDefinition> unionTypes = new ArrayList<TypeDefinition>();
                for (APITypeModel typeModel : apiTypeModel.getUnionTypes()) {
                    TypeDefinition typeDefinition = this.buildTypeDefinition(typeModel, null, mediaType);
                    unionTypes.add(typeDefinition);
                }
                return typeDefinitionBuilder.buildUnionTypeDefinition(unionTypes);
            }
            case MULTIPART: {
                ArrayList<PartParameter> parts = new ArrayList<PartParameter>();
                for (APIParameterModel apiParameterModel : apiTypeModel.getParts()) {
                    PartDescriptor partDescriptor = null;
                    if (partDescriptors != null) {
                        partDescriptor = partDescriptors.stream().filter(x -> x.getPartName().equals(apiParameterModel.getExternalName())).findFirst().orElse(null);
                    }
                    PartParameter partParameter = this.parameterBuilder.buildPartParameter(apiParameterModel, partDescriptor);
                    parts.add(partParameter);
                }
                return typeDefinitionBuilder.buildMultipartTypeDefinition(parts);
            }
        }
        throw new IllegalArgumentException("Current type '" + apiType + "' is not supported.");
    }

    public TypeDefinition buildTypeDefinition(String rawSchema, MediaType mediaType) throws ModelGenerationException {
        TypeSchema typeSchema = this.typeSchemaBuilder.buildTypeSchema(rawSchema);
        if (mediaType == null) {
            mediaType = typeSchema instanceof XmlTypeSchema ? MediaType.APPLICATION_XML_TYPE : MediaType.APPLICATION_JSON_TYPE;
        }
        return TypeDefinition.builder(mediaType, typeSchema, null, null).buildObjectTypeDefinition();
    }

    private PrimitiveTypeDefinition.PrimitiveType buildPrimitiveType(APIPrimitiveTypeModel primitiveTypeModel) {
        switch (primitiveTypeModel.getPrimitiveType()) {
            case BOOLEAN: {
                return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
            }
            case DATE: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE;
            }
            case DATE_ONLY: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY;
            }
            case DATE_TIME_ONLY: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY;
            }
            case DATE_TIME: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME;
            }
            case FILE: {
                return PrimitiveTypeDefinition.PrimitiveType.FILE;
            }
            case NUMBER: {
                return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
            }
            case INTEGER: {
                return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
            }
            case STRING: {
                return PrimitiveTypeDefinition.PrimitiveType.STRING;
            }
            case TIME_ONLY: {
                return PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY;
            }
        }
        throw new IllegalArgumentException("Primitive Type not supported. Should not reach here.");
    }

    public TypeDefinition buildPrimitiveType(DataTypeDescriptor dataType) {
        PrimitiveTypeDefinition.PrimitiveType type;
        switch (dataType) {
            case STRING: {
                type = PrimitiveTypeDefinition.PrimitiveType.STRING;
                break;
            }
            case INTEGER: {
                type = PrimitiveTypeDefinition.PrimitiveType.INTEGER;
                break;
            }
            case NUMBER: {
                type = PrimitiveTypeDefinition.PrimitiveType.NUMBER;
                break;
            }
            case ZONED_DATE_TIME: {
                type = PrimitiveTypeDefinition.PrimitiveType.ZONED_DATE_TIME;
                break;
            }
            case LOCAL_DATE_TIME: {
                type = PrimitiveTypeDefinition.PrimitiveType.LOCAL_DATE_TIME;
                break;
            }
            case BOOLEAN: {
                type = PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Primitive Type not supported. Should not reach here.");
            }
        }
        return TypeDefinition.simplePrimitiveType(type);
    }
}

