/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorArgumentBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.DataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.ScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.DataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.ScriptDataExpressionDescriptor;

public class ConnectorDataExpressionBuilder {
    private final ConnectorArgumentBuilder connectorArgumentBuilder = new ConnectorArgumentBuilder();

    public DataExpression buildDataExpression(DataExpressionDescriptor dataExpressionDescriptor) {
        if (dataExpressionDescriptor instanceof HttpRequestDataExpressionDescriptor) {
            return this.buildHttpRequestDataExpression((HttpRequestDataExpressionDescriptor)dataExpressionDescriptor);
        }
        if (dataExpressionDescriptor instanceof ScriptDataExpressionDescriptor) {
            return this.buildScriptDataExpression((ScriptDataExpressionDescriptor)dataExpressionDescriptor);
        }
        throw new IllegalArgumentException("DataExpression not supported, this is a bug.");
    }

    public HttpRequestDataExpression buildHttpRequestDataExpression(HttpRequestDataExpressionDescriptor httpRequestDescriptor) {
        return new HttpRequestDataExpression(httpRequestDescriptor.getPath(), HTTPMethod.fromString(httpRequestDescriptor.getMethod().getName()), this.buildHttpRequestBinding(httpRequestDescriptor.getBindings()));
    }

    private HttpRequestBinding buildHttpRequestBinding(HttpRequestDataExpressionBindingDescriptor bindingDescriptor) {
        if (bindingDescriptor == null) {
            return null;
        }
        return new HttpRequestBinding(this.connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getUriParameters()), this.connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getQueryParameters()), this.connectorArgumentBuilder.buildArgumentList(bindingDescriptor.getHeaders()));
    }

    public ScriptDataExpression buildScriptDataExpression(ScriptDataExpressionDescriptor scriptDescriptor) {
        if (scriptDescriptor == null) {
            return null;
        }
        return new ScriptDataExpression(scriptDescriptor.getLanguage(), scriptDescriptor.getExpression());
    }
}

