/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorDataExpressionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ConnectorResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.DwScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.DataWeaveExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataSameOperationDefinitionDescriptor;
import java.util.List;
import java.util.stream.Collectors;

public class ConnectorSampleDataBuilder {
    private final ConnectorResolverBuilder connectorResolverBuilder = new ConnectorResolverBuilder();
    private final ConnectorDataExpressionBuilder connectorDataExpressionBuilder = new ConnectorDataExpressionBuilder();

    public ResolverExpression<SampleDataDefinition> buildSampleData(ResolverExpressionDescriptor<SampleDataDefinitionDescriptor> sampleDataExpressionDescriptor, ConnectorOperation connectorOperation, Trigger trigger) {
        if (sampleDataExpressionDescriptor == null) {
            return null;
        }
        if (sampleDataExpressionDescriptor instanceof ResolverReferenceDescriptor) {
            ResolverReferenceDescriptor resolverReference = (ResolverReferenceDescriptor)sampleDataExpressionDescriptor;
            return this.connectorResolverBuilder.buildResolverReference(resolverReference, this.buildSampleDataDefinition((SampleDataDefinitionDescriptor)resolverReference.getDeclaration().getDefinition()));
        }
        if (sampleDataExpressionDescriptor instanceof ResolverDefinitionDescriptor) {
            SampleDataDefinitionDescriptor definition = (SampleDataDefinitionDescriptor)sampleDataExpressionDescriptor;
            if (definition instanceof SampleDataSameOperationDefinitionDescriptor) {
                if (connectorOperation != null) {
                    return this.buildSampleDataSameOperationDefinition(connectorOperation);
                }
                if (trigger != null) {
                    return this.buildSampleDataSameOperationDefinition(trigger);
                }
                throw new IllegalArgumentException("SampleData target not supported. This is a bug.");
            }
            return this.buildSampleDataDefinition(definition);
        }
        throw new IllegalArgumentException("ResolverExpressionDescriptor not supported, this is a bug.");
    }

    private SampleDataDefinition buildSampleDataSameOperationDefinition(ConnectorOperation connectorOperation) {
        DwScriptDataExpression paginationExpression = null;
        if (connectorOperation.hasPagination()) {
            paginationExpression = new DwScriptDataExpression(connectorOperation.getPagination().getPaginationResponseExpression());
        }
        return new SampleDataDefinition(new HttpRequestDataExpression(connectorOperation.getPath(), HTTPMethod.fromString(connectorOperation.getHttpMethod()), this.buildBindings(connectorOperation)), paginationExpression);
    }

    private SampleDataDefinition buildSampleDataSameOperationDefinition(Trigger trigger) {
        return new SampleDataDefinition(new HttpRequestDataExpression(trigger.getOperation().getPath(), HTTPMethod.fromString(trigger.getOperation().getHttpMethod()), this.buildTriggerBindings(trigger)), new DwScriptDataExpression(this.getExpressionForFirstItem(trigger.getItemsExpression())));
    }

    private String getExpressionForFirstItem(String expression) {
        if (expression.startsWith("#[") && expression.endsWith("]")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        return "(" + expression + ")[0]";
    }

    private HttpRequestBinding buildTriggerBindings(Trigger trigger) {
        if (trigger.getParameterBindings() == null || trigger.getParameterBindings().isEmpty()) {
            return null;
        }
        return new HttpRequestBinding(this.buildTriggerArguments(trigger, ParameterType.URI), this.buildTriggerArguments(trigger, ParameterType.QUERY), this.buildTriggerArguments(trigger, ParameterType.HEADER));
    }

    private List<Argument> buildTriggerArguments(Trigger trigger, ParameterType parameterType) {
        return trigger.getParameterBindings().stream().filter(x -> x.getParameterType().equals((Object)parameterType)).map(x -> this.buildArgument(x.getName(), x.getExpression())).collect(Collectors.toList());
    }

    private HttpRequestBinding buildBindings(ConnectorOperation connectorOperation) {
        List<Parameter> requiredUriParams = this.getRequiredParameters(connectorOperation.getUriParameters());
        List<Parameter> requiredQueryParams = this.getRequiredParameters(connectorOperation.getQueryParameters());
        List<Parameter> requiredHeaders = this.getRequiredParameters(connectorOperation.getHeaders());
        if (requiredUriParams.isEmpty() && requiredQueryParams.isEmpty() && requiredHeaders.isEmpty()) {
            return null;
        }
        return new HttpRequestBinding(this.buildArguments(requiredUriParams, ParameterType.URI), this.buildArguments(requiredQueryParams, ParameterType.QUERY), this.buildArguments(requiredHeaders, ParameterType.HEADER));
    }

    private List<Parameter> getRequiredParameters(List<Parameter> parameterList) {
        return parameterList.stream().filter(Parameter::isRequired).collect(Collectors.toList());
    }

    private List<Argument> buildArguments(List<Parameter> parameters, ParameterType parameterType) {
        return parameters.stream().map(x -> this.buildArgument(x.getExternalName(), parameterType)).collect(Collectors.toList());
    }

    private Argument buildArgument(String externalName, ParameterType parameterType) {
        return this.buildArgument(externalName, String.format("%s.%s", parameterType.getAccessorName(), externalName));
    }

    private Argument buildArgument(String externalName, String expression) {
        return new Argument(externalName, new DataWeaveExpression(expression));
    }

    private SampleDataDefinition buildSampleDataDefinition(SampleDataDefinitionDescriptor sampleDataDefinitionDescriptor) {
        return new SampleDataDefinition(this.connectorDataExpressionBuilder.buildHttpRequestDataExpression(sampleDataDefinitionDescriptor.getResult()), this.connectorDataExpressionBuilder.buildScriptDataExpression(sampleDataDefinitionDescriptor.getTransform()));
    }
}

