/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.metadata.OverrideResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AuxiliarParameterBindingBuilder {

  private final String name;
  private final ParameterType parameterType;
  private final TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
  private String value;
  private Boolean ignored;
  private final List<FieldBuilder> fieldBuilders = new ArrayList<>();
  private final OverrideResolverBuilder overrideResolverBuilder = new OverrideResolverBuilder();

  public AuxiliarParameterBindingBuilder(String name, ParameterType parameterType) {
    requireNonNull(name);
    requireNonNull(parameterType);

    this.name = name;
    this.parameterType = parameterType;
  }

  public String getName() {
    return name;
  }

  public ParameterType getParameterType() {
    return parameterType;
  }

  public TypeDefinitionBuilder getTypeDefinitionBuilder() {
    return typeDefinitionBuilder;
  }

  public Boolean getIgnored() {
    return ignored;
  }

  public List<FieldBuilder> getFieldBuilders() {
    return fieldBuilders;
  }

  public OverrideResolverBuilder getHttpOverrideResolverBuilder() {
    return overrideResolverBuilder;
  }

  public AuxiliarParameterBindingBuilder value(String value) {
    this.value = defaultIfNull(value, this.value);
    return this;
  }

  public AuxiliarParameterBindingBuilder ignored(Boolean ignored) {
    this.ignored = defaultIfNull(ignored, this.ignored);
    return this;
  }

  ParameterBinding build() {
    List<Field> fields = fieldBuilders.stream().map(fieldBuilder -> fieldBuilder.buildField())
        .collect(Collectors.toList());
    return new ParameterBinding(parameterType, name, value, ignored != null && ignored, fields,
                                overrideResolverBuilder.build());
  }
}
