/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata;

import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.ScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;

public class SampleDataDefinitionBuilder extends ResolverDefinitionBuilder<SampleDataDefinition> {

  private HttpRequestDataExpression httpRequestDataExpression;
  private ScriptDataExpression scriptDataExpression;
  private String script;
  private String fqn;

  public SampleDataDefinitionBuilder httpRequestDataExpression(HttpRequestDataExpression httpRequestDataExpression) {
    this.httpRequestDataExpression = defaultIfNull(httpRequestDataExpression, this.httpRequestDataExpression);
    return this;
  }

  public SampleDataDefinitionBuilder scriptDataExpression(ScriptDataExpression scriptDataExpression) {
    this.scriptDataExpression = defaultIfNull(scriptDataExpression, this.scriptDataExpression);
    return this;
  }

  public SampleDataDefinitionBuilder scriptReturnValue(String script) {
    this.script = defaultIfNull(script, this.script);
    return this;
  }

  public SampleDataDefinitionBuilder fqn(String fqn) {
    this.fqn = defaultIfNull(fqn, this.fqn);
    return this;
  }

  public SampleDataDefinition build() {
    return new SampleDataDefinition(httpRequestDataExpression, scriptDataExpression, script, fqn);
  }

}
