/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic;

public enum ParameterDataType {

  STRING("string"), INTEGER("integer"), NUMBER("number"), BOOLEAN("boolean"), LOCAL_DATE_TIME("localDateTime"), ZONED_DATE_TIME(
      "zonedDateTime"), LONG("long"), BINARY("binary");

  private final String name;

  ParameterDataType(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static ParameterDataType forName(String name) {
    if (name.equalsIgnoreCase(STRING.getName())) {
      return STRING;
    } else if (name.equalsIgnoreCase(INTEGER.getName())) {
      return INTEGER;
    } else if (name.equalsIgnoreCase(LONG.getName())) {
      return LONG;
    } else if (name.equalsIgnoreCase(NUMBER.getName())) {
      return NUMBER;
    } else if (name.equalsIgnoreCase(BOOLEAN.getName())) {
      return BOOLEAN;
    } else if (name.equalsIgnoreCase(LOCAL_DATE_TIME.getName())) {
      return LOCAL_DATE_TIME;
    } else if (name.equalsIgnoreCase(ZONED_DATE_TIME.getName())) {
      return ZONED_DATE_TIME;
    } else if (name.equalsIgnoreCase(BINARY.getName())) {
      return BINARY;
    }

    throw new IllegalArgumentException(name + " is not a valid trigger parameter type. This is a bug.");
  }
}
