/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorDataExpressionLoader.loadRequestDataExpression;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.metadata.OverrideResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OverrideResolverDescriptor;

public class DescriptorOverrideResolverLoader {

  public static void loadHttpOverrideResolver(OverrideResolverDescriptor overrideResolverDescriptor,
                                              OverrideResolverBuilder overrideResolverBuilder) {

    if (overrideResolverDescriptor == null) {
      return;
    }

    HttpRequestDataExpression request = loadRequestDataExpression(overrideResolverDescriptor.getRequest());

    overrideResolverBuilder
        .request(request)
        .transformationScript(overrideResolverDescriptor.getTransformationScript());
  }

}
