/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TypeSchemaPool {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Map<String, TypeSchema> innerSchemaPool = new HashMap<String, TypeSchema>();

    public TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
        String rawSchema = typeSchema.getRawSchema();
        try {
            rawSchema = TypeSchemaPool.getCanonicalJson(rawSchema);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.innerSchemaPool.computeIfAbsent(rawSchema, str -> typeSchema);
    }

    static String getCanonicalJson(String json) throws IOException {
        JsonNode jsonNode = MAPPER.readTree(json);
        jsonNode = TypeSchemaPool.canonicalize(jsonNode, new JsonNodeFactory(true));
        return MAPPER.writeValueAsString((Object)jsonNode);
    }

    private static JsonNode canonicalize(JsonNode jsonNode, JsonNodeFactory nf) {
        if (jsonNode instanceof ObjectNode) {
            TreeMap k = new TreeMap();
            jsonNode.fields().forEachRemaining(e -> k.put(e.getKey(), TypeSchemaPool.canonicalize((JsonNode)e.getValue(), nf)));
            return new ObjectNode(nf, k);
        }
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = new ArrayNode(nf, jsonNode.size());
            jsonNode.elements().forEachRemaining(el -> arrayNode.add(TypeSchemaPool.canonicalize(el, nf)));
            return arrayNode;
        }
        if (jsonNode instanceof ValueNode) {
            return jsonNode;
        }
        throw new RuntimeException("node " + jsonNode + " (" + jsonNode.getClass() + ") not supported");
    }
}

