/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.FieldBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.metadata.OverrideResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.BodyIdentifierExpressionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class BodyBuilder {
    private String bodyIdentifier;
    private final List<FieldBuilder> fieldBuilders = new ArrayList<FieldBuilder>();
    private final OverrideResolverBuilder overrideResolverBuilder = new OverrideResolverBuilder();

    public Body buildBody(BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler, String operationId, String method, String path) {
        List<Field> fields = this.fieldBuilders.stream().map(fieldBuilder -> fieldBuilder.buildField()).collect(Collectors.toList());
        return new Body(this.buildBodyIdentifier(bodyIdentifierExpressionHandler, operationId, method, path), fields, this.overrideResolverBuilder.build());
    }

    private String buildBodyIdentifier(BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler, String operationId, String method, String path) {
        String result = this.bodyIdentifier;
        if (this.bodyIdentifier == null) {
            result = bodyIdentifierExpressionHandler.evaluate(operationId, method, path, null);
        }
        return result;
    }

    public BodyBuilder bodyIdentifier(String bodyIdentifier) {
        this.bodyIdentifier = (String)ObjectUtils.defaultIfNull((Object)bodyIdentifier, (Object)this.bodyIdentifier);
        return this;
    }

    public String getBodyIdentifier() {
        return this.bodyIdentifier;
    }

    public List<FieldBuilder> getFieldBuilders() {
        return this.fieldBuilders;
    }

    public OverrideResolverBuilder getHttpOverrideResolverBuilder() {
        return this.overrideResolverBuilder;
    }
}

