/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoaderConfiguration;
import com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ObjectHolder;
import java.util.Map;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.impl.DefaultNullType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.weave.v2.el.metadata.EmptyCallBack;
import org.mule.weave.v2.el.metadata.WeaveMetadataServiceProvider;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class SchemaInferenceService {
    private static final String PAYLOAD = "payload";
    private static final String LOCATION = "location";
    private static final String[] IMPLICIT_INPUTS = new String[]{"payload", "location"};
    private static final DataWeaveScript SCRIPT = ExpressionHandlerUtils.compileDataWeaveScript(SchemaInferenceService.class, "schemaInference.dwl", IMPLICIT_INPUTS);
    private static final ExpressionLanguageMetadataService metadataService = (ExpressionLanguageMetadataService)new WeaveMetadataServiceProvider().getServiceDefinition().getService();

    public String changeSchemaRef(String schema, String location) {
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        scriptingBindings.addBinding(PAYLOAD, (Object)schema, "application/json");
        scriptingBindings.addBinding(LOCATION, (Object)location, "application/java");
        DataWeaveResult dataWeaveResult = SCRIPT.write(scriptingBindings, ServiceManager.apply());
        return dataWeaveResult.getContentAsString();
    }

    public String inferSchema(String schema, String expression, MetadataUtils.LocationType locationType) {
        RestJsonTypeLoader restJsonTypeLoader = new RestJsonTypeLoader(schema, RestJsonTypeLoaderConfiguration.builder().traceSubSchemaLocation().build());
        MetadataType metadataType = restJsonTypeLoader.load("id").orElse(null);
        ObjectTypeBuilder response = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).objectType();
        response.addField().key(DWBindings.BODY.getBinding()).value(metadataType);
        TypeBindings typeBindings = TypeBindings.builder().addBinding(PAYLOAD, metadataType).addBinding(DWBindings.RESPONSE.getBinding(), (MetadataType)response.build()).build();
        MetadataType outputType = metadataService.getOutputType(typeBindings, ExpressionHandlerUtils.curateScript(expression), (ExpressionLanguageMetadataService.MessageCallback)new EmptyCallBack());
        return this.findLocation(outputType, locationType);
    }

    public MetadataType inferSchema(String expression, Map<String, MetadataType> bindings) {
        TypeBindings.Builder typeBindings = TypeBindings.builder();
        bindings.entrySet().forEach(binding -> typeBindings.addBinding((String)binding.getKey(), (MetadataType)binding.getValue()));
        MetadataType result = metadataService.getOutputType(typeBindings.build(), ExpressionHandlerUtils.curateScript(expression), (ExpressionLanguageMetadataService.MessageCallback)new EmptyCallBack());
        if (result instanceof DefaultUnionType && ((DefaultUnionType)result).getTypes().removeIf(x -> x.getClass().equals(DefaultNullType.class)) && ((DefaultUnionType)result).getTypes().size() == 1) {
            return (MetadataType)((DefaultUnionType)result).getTypes().get(0);
        }
        return result;
    }

    public static MetadataType getSchemaMetadataType(String schema) {
        RestJsonTypeLoader restJsonTypeLoader = new RestJsonTypeLoader(schema, RestJsonTypeLoaderConfiguration.builder().traceSubSchemaLocation().build());
        return restJsonTypeLoader.load("id").orElse(null);
    }

    private String findLocation(MetadataType metadataType, final MetadataUtils.LocationType locationType) {
        final ObjectHolder<Object> objectHolder = new ObjectHolder<Object>(null);
        metadataType.accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                super.visitArrayType(arrayType);
                this.setLocation((MetadataType)(MetadataUtils.LocationType.ITEM.equals((Object)locationType) ? arrayType.getType() : arrayType));
            }

            public void visitUnion(UnionType unionType) {
                super.visitUnion(unionType);
                unionType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
            }

            public void visitIntersection(IntersectionType intersectionType) {
                super.visitIntersection(intersectionType);
                intersectionType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
            }

            public void visitTuple(TupleType tupleType) {
                super.visitTuple(tupleType);
                tupleType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
            }

            private void setLocation(MetadataType metadataType) {
                objectHolder.set(SchemaInferenceService.this.getSubSchemaLocation(metadataType));
            }
        });
        return objectHolder.get();
    }

    private String getSubSchemaLocation(MetadataType metadataType) {
        return metadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class).map(MetadataFormatPropertiesAnnotation::getValue).map(f -> (String)f.get("subSchemaLocation")).orElse(null);
    }
}

