/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.documentation.Documentation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiParameterLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIDocumentationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import java.util.stream.Collectors;

public class ApiOperationLoader {
    static void loadOperations(APIModel apiModel, ConnectorModelBuilder connectorModelBuilder) {
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            OperationBuilder connectorOperationBuilder = connectorModelBuilder.getOrCreateOperationBuilder(apiOperation.getOperationId(), apiOperation.getPath(), apiOperation.getHttpMethod(), apiOperation.getSummary(), ApiOperationLoader.toDocumentation(apiOperation.getAPIDocumentationModel()));
            ApiOperationLoader.loadOperation(apiOperation, connectorOperationBuilder);
        }
    }

    private static Documentation toDocumentation(APIDocumentationModel apiDocumentationModel) {
        if (apiDocumentationModel == null) {
            return null;
        }
        return new Documentation(apiDocumentationModel.getDescription(), apiDocumentationModel.getUrl());
    }

    private static void loadOperation(APIOperationModel apiOperation, OperationBuilder connectorOperationBuilder) {
        connectorOperationBuilder.displayName(apiOperation.getName()).description(apiOperation.getDescription()).baseUris(apiOperation.getBaseUris()).securitySchemes(apiOperation.getSecuritySchemesModel().stream().map(APISecuritySchemeModel::getName).collect(Collectors.toList()));
        ApiParameterLoader.loadOperationParameters(apiOperation.getUriParamsModel(), connectorOperationBuilder);
        ApiParameterLoader.loadOperationParameters(apiOperation.getQueryParamsModel(), connectorOperationBuilder);
        ApiParameterLoader.loadOperationParameters(apiOperation.getHeadersModel(), connectorOperationBuilder);
        ApiTypeLoader.loadInputTypeDefinitions(apiOperation.getInputMetadataModel(), connectorOperationBuilder);
        ApiTypeLoader.loadOutputTypeDefinitions(apiOperation.getOutputMetadataModel(), connectorOperationBuilder);
    }
}

