/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;

public enum ParameterType {
    URI("uriParam", "uriParameter", "uriParameters"),
    QUERY("queryParam", "queryParameter", "queryParameters"),
    HEADER("header", "header", "headers"),
    PART("part", "", ""),
    SECURITY("security", "", ""),
    TRIGGER("trigger", "parameter", "parameters"),
    BODY("body", "body", "body"),
    AUXILIAR("auxiliar", "parameters", "parameters"),
    CONNECTION("connection", "connection", "connection"),
    CONFIGURATION("configuration", "configuration", "configuration");

    private final String name;
    private final String accessorName;
    private final String binding;

    private ParameterType(String shortName, String accessorName, String binding) {
        this.name = shortName;
        this.accessorName = accessorName;
        this.binding = binding;
    }

    public String getName() {
        return this.name;
    }

    public String getAccessorName() {
        return this.accessorName;
    }

    public String getBinding() {
        return this.binding;
    }

    public APIParameterType getApiParameterType() {
        try {
            return APIParameterType.valueOf((String)this.name());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException("ParameterType " + this.name() + " can't be converted to APIParameterType");
        }
    }

    public static ParameterType fromBinding(String binding) {
        for (ParameterType parameterType : ParameterType.values()) {
            if (!parameterType.getBinding().equalsIgnoreCase(binding)) continue;
            return parameterType;
        }
        return null;
    }
}

