/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.metadata;

import static org.apache.commons.lang3.StringUtils.isEmpty;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.metadata.OverrideResolver;

public class OverrideResolverBuilder {

  private HttpRequestDataExpression request;
  private String transformationScript;

  public OverrideResolverBuilder request(HttpRequestDataExpression request) {
    this.request = request;
    return this;
  }

  public OverrideResolverBuilder transformationScript(String transformationScript) {
    this.transformationScript = transformationScript;
    return this;
  }

  public OverrideResolver build() {
    if (request == null || isEmpty(transformationScript)) {
      return null;
    }
    return new OverrideResolver(request, transformationScript);
  }
}
