/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;

public abstract class BaseParameter {

  protected final String externalName;
  protected final String internalName;
  protected final String displayName;
  protected final String muleAlias;
  protected final ParameterDataType dataType;
  protected TypeDefinition typeDefinition;
  protected final String description;
  protected final Boolean required;
  protected final ParameterType parameterType;
  private final String muleMetadataKeyId;
  private final String muleTypeResolver;
  private final Boolean muleContent;
  private final ResolverExpression<ValueProviderDefinition> valueProvider;
  protected final String summary;

  public BaseParameter(String externalName, String displayName, ParameterDataType dataType, TypeDefinition typeDefinition,
                       String muleAlias, String description, Boolean required, ParameterType parameterType,
                       String muleMetadataKeyId, String muleTypeResolver, Boolean muleContent,
                       ResolverExpression<ValueProviderDefinition> valueProvider, String summary) {
    this(externalName, getXmlName(externalName), displayName, dataType,
         typeDefinition, muleAlias, description, required, parameterType, muleMetadataKeyId, muleTypeResolver,
         muleContent, valueProvider, summary);
  }

  public BaseParameter(String externalName, String internalName, String displayName, ParameterDataType dataType,
                       TypeDefinition typeDefinition, String muleAlias,
                       String description, Boolean required, ParameterType parameterType,
                       String muleMetadataKeyId, String muleTypeResolver, Boolean muleContent,
                       ResolverExpression<ValueProviderDefinition> valueProvider, String summary) {
    this.externalName = externalName;
    this.internalName = internalName;
    this.muleAlias = muleAlias;
    this.dataType = dataType;
    this.displayName = displayName;
    this.typeDefinition = typeDefinition;
    this.description = description;
    this.required = required;
    this.parameterType = parameterType;
    this.muleMetadataKeyId = muleMetadataKeyId;
    this.muleTypeResolver = muleTypeResolver;
    this.muleContent = muleContent;
    this.valueProvider = valueProvider;
    this.summary = summary;
  }

  public String getExternalName() {
    return externalName;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getDisplayName() {
    return displayName;
  }

  public String getMuleAlias() {
    return muleAlias;
  }

  public ParameterDataType getType() {
    return dataType;
  }

  public TypeDefinition getTypeDefinition() {
    return typeDefinition;
  }

  public String getDescription() {
    return description;
  }

  public Boolean isRequired() {
    return required;
  }

  public ParameterType getParameterType() {
    return parameterType;
  }

  public String getMuleMetadataKeyId() {
    return muleMetadataKeyId;
  }

  public String getMuleTypeResolver() {
    return muleTypeResolver;
  }

  public Boolean getMuleContent() {
    return muleContent;
  }

  public ResolverExpression<ValueProviderDefinition> getValueProvider() {
    return valueProvider;
  }

  public String getSummary() {
    return summary;
  }
}
