/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIParameterType;

public enum ParameterType {

  URI("uriParam", "uriParameter", "uriParameters"), QUERY("queryParam", "queryParameter", "queryParameters"), HEADER("header",
      "header", "headers"), PART("part", EMPTY, EMPTY), SECURITY("security", EMPTY, EMPTY), TRIGGER("trigger", "parameter",
          "parameters"), BODY("body", "body", "body"), AUXILIAR("auxiliar", "parameters", "parameters"),

  CONNECTION("connection",
      "connection", "connection"), CONFIGURATION("configuration", "configuration", "configuration");

  private final String name;
  private final String accessorName;
  private final String binding;

  ParameterType(String shortName, String accessorName, String binding) {
    this.name = shortName;
    this.accessorName = accessorName;
    this.binding = binding;
  }

  public String getName() {
    return name;
  }

  public String getAccessorName() {
    return accessorName;
  }

  public String getBinding() {
    return binding;
  }

  /**
   * Returns the corresponding {@link APIParameterType} value.
   */
  public APIParameterType getApiParameterType() {
    try {
      return APIParameterType.valueOf(name());
    } catch (IllegalArgumentException e) {
      throw new UnsupportedOperationException("ParameterType " + name() + " can't be converted to APIParameterType");
    }
  }

  public static ParameterType fromBinding(String binding) {
    for (ParameterType parameterType : ParameterType.values()) {
      if (parameterType.getBinding().equalsIgnoreCase(binding)) {
        return parameterType;
      }
    }
    return null;
  }
}
