/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;

import javax.ws.rs.core.MediaType;
import java.util.List;

public class MultipartTypeDefinition extends TypeDefinition {


  private final List<PartParameter> parts;

  public MultipartTypeDefinition(String example, List<String> enumValues, TypeSchema typeSchema, List<PartParameter> parts,
                                 String displayName, String description, Boolean required) {
    super(MediaType.MULTIPART_FORM_DATA_TYPE, example, enumValues, typeSchema, displayName, description, required);
    this.parts = parts;
  }

  public List<PartParameter> getParts() {
    return parts;
  }
}
