/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorConfiguration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorPackage;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.BaseUriBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.InterceptorBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.PaginationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.documentation.Documentation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.BodyIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationDisplayNameExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BaseEndpointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.weave.v2.parser.phase.CompilationException;

public class ConnectorModelBuilder {
    private static final Protocol[] DEFAULT_PROTOCOLS = new Protocol[]{Protocol.HTTP, Protocol.HTTPS};
    private String connectorName;
    private String connectorDescription;
    private String mavenGroup;
    private String mavenArtifactId;
    private String mavenVersion;
    private String baseJavaPackage;
    private ConnectorCategory connectorCategory;
    private List<Protocol> supportedProtocols;
    private String extensionXml;
    private QueryParamArrayFormat queryParamArrayFormat;
    private final List<PaginationBuilder> paginationBuilders = new ArrayList<PaginationBuilder>();
    private final List<OperationBuilder> operationBuilders = new ArrayList<OperationBuilder>();
    private final List<TriggerBuilder> triggerBuilders = new ArrayList<TriggerBuilder>();
    private final List<SecuritySchemeBuilder> securitySchemeBuilders = new ArrayList<SecuritySchemeBuilder>();
    private final BaseUriBuilder baseUriBuilder = new BaseUriBuilder();
    private Boolean skipOutputTypeValidation;
    private String operationIdentifierExpression;
    private String operationDisplayNameExpression;
    private String parameterIdentifierExpression;
    private String bodyIdentifierExpression;
    private MediaType defaultInputMediaType;
    private MediaType defaultOutputMediaType;
    private TestConnectionConfig testConnectionConfig;
    private ConnectorConfiguration connectorConfiguration;
    private final List<InterceptorBuilder> interceptorBuilders = new ArrayList<InterceptorBuilder>();

    public ConnectorModelBuilder name(String connectorName) {
        this.connectorName = (String)ObjectUtils.defaultIfNull((Object)connectorName, (Object)this.connectorName);
        return this;
    }

    public ConnectorModelBuilder description(String connectorDescription) {
        this.connectorDescription = (String)ObjectUtils.defaultIfNull((Object)connectorDescription, (Object)this.connectorDescription);
        return this;
    }

    public ConnectorModelBuilder mavenGroup(String mavenGroup) {
        this.mavenGroup = (String)ObjectUtils.defaultIfNull((Object)mavenGroup, (Object)this.mavenGroup);
        return this;
    }

    public ConnectorModelBuilder mavenArtifactId(String mavenArtifactId) {
        this.mavenArtifactId = (String)ObjectUtils.defaultIfNull((Object)mavenArtifactId, (Object)this.mavenArtifactId);
        return this;
    }

    public ConnectorModelBuilder mavenVersion(String mavenVersion) {
        this.mavenVersion = (String)ObjectUtils.defaultIfNull((Object)mavenVersion, (Object)this.mavenVersion);
        return this;
    }

    public ConnectorModelBuilder baseJavaPackage(String baseJavaPackage) {
        this.baseJavaPackage = (String)ObjectUtils.defaultIfNull((Object)baseJavaPackage, (Object)this.baseJavaPackage);
        return this;
    }

    public ConnectorModelBuilder category(ConnectorCategory connectorCategory) {
        this.connectorCategory = (ConnectorCategory)((Object)ObjectUtils.defaultIfNull((Object)((Object)connectorCategory), (Object)((Object)this.connectorCategory)));
        return this;
    }

    public ConnectorModelBuilder supportedProtocols(List<Protocol> protocols) {
        this.supportedProtocols = (List)ObjectUtils.defaultIfNull(protocols, this.supportedProtocols);
        return this;
    }

    public ConnectorModelBuilder queryParamArrayFormat(QueryParamArrayFormat queryParamArrayFormat) {
        this.queryParamArrayFormat = (QueryParamArrayFormat)((Object)ObjectUtils.defaultIfNull((Object)((Object)queryParamArrayFormat), (Object)((Object)this.queryParamArrayFormat)));
        return this;
    }

    public ConnectorModelBuilder extensionXml(String extensionXml) {
        this.extensionXml = (String)ObjectUtils.defaultIfNull((Object)extensionXml, (Object)this.extensionXml);
        return this;
    }

    public BaseUriBuilder getBaseUriBuilder() {
        return this.baseUriBuilder;
    }

    public String getOperationIdentifierExpression() {
        return this.operationIdentifierExpression;
    }

    public String getParameterIdentifierExpression() {
        return this.parameterIdentifierExpression;
    }

    public String getBodyIdentifierExpression() {
        return this.bodyIdentifierExpression;
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public ConnectorModelBuilder skipOutputTypeValidation(Boolean skipOutputTypeValidation) {
        this.skipOutputTypeValidation = (Boolean)ObjectUtils.defaultIfNull((Object)skipOutputTypeValidation, (Object)this.skipOutputTypeValidation);
        return this;
    }

    public ConnectorModelBuilder operationDisplayNameExpression(String operationDisplayNameExpression) {
        this.operationDisplayNameExpression = (String)ObjectUtils.defaultIfNull((Object)operationDisplayNameExpression, (Object)this.operationDisplayNameExpression);
        return this;
    }

    public ConnectorModelBuilder operationIdentifierExpression(String operationIdentifierExpression) {
        this.operationIdentifierExpression = operationIdentifierExpression;
        return this;
    }

    public ConnectorModelBuilder parameterIdentifierExpression(String parameterIdentifierExpression) {
        this.parameterIdentifierExpression = parameterIdentifierExpression;
        return this;
    }

    public ConnectorModelBuilder bodyIdentifierExpression(String bodyIdentifierExpression) {
        this.bodyIdentifierExpression = bodyIdentifierExpression;
        return this;
    }

    public MediaType getDefaultInputMediaType() {
        return this.defaultInputMediaType;
    }

    public ConnectorModelBuilder defaultInputMediaType(MediaType defaultInputMediaType) {
        this.defaultInputMediaType = defaultInputMediaType;
        return this;
    }

    public MediaType getDefaultOutputMediaType() {
        return this.defaultOutputMediaType;
    }

    public ConnectorModelBuilder defaultOutputMediaType(MediaType defaultOutputMediaType) {
        this.defaultOutputMediaType = defaultOutputMediaType;
        return this;
    }

    public ConnectorModelBuilder testConnection(TestConnectionConfig testConnectionConfig) {
        this.testConnectionConfig = testConnectionConfig;
        return this;
    }

    public ConnectorModelBuilder connectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        this.connectorConfiguration = connectorConfiguration;
        return this;
    }

    public List<OperationBuilder> getOperationBuilders() {
        return this.operationBuilders;
    }

    public List<OperationBuilder> getOperationBuildersByPath(String path) {
        return this.operationBuilders.stream().filter(x -> x.getPath().equalsIgnoreCase(path)).collect(Collectors.toList());
    }

    public Optional<OperationBuilder> getOperationBuildersByOperationId(BaseEndpointDescriptor baseOperation) {
        return this.operationBuilders.stream().filter(x -> this.matchesOperationIdOrMethodAndPath((OperationBuilder)x, baseOperation)).findFirst();
    }

    public Optional<OperationBuilder> getOperationBuildersByOperationIdOrMethodPath(BaseEndpointDescriptor baseEndpointDescriptor) {
        if (baseEndpointDescriptor != null) {
            Optional<OperationBuilder> operationBuilderByOperationId = this.operationBuilders.stream().filter(x -> this.matchesDescriptorIdentifierOperationAdapter((OperationBuilder)x, baseEndpointDescriptor)).findFirst();
            return operationBuilderByOperationId.isPresent() ? operationBuilderByOperationId : this.operationBuilders.stream().filter(x -> this.matchesOperationIdOrMethodAndPath((OperationBuilder)x, baseEndpointDescriptor)).findFirst();
        }
        return Optional.empty();
    }

    private boolean matchesDescriptorIdentifierOperationAdapter(OperationBuilder operationBuilder, BaseEndpointDescriptor baseEndpointDescriptor) {
        return operationBuilder.isAdapter() && operationBuilder.getDescriptorIdentifier().equals(baseEndpointDescriptor.getOperationStringIdentifier());
    }

    private boolean matchesOperationIdOrMethodAndPath(OperationBuilder operationBuilder, BaseEndpointDescriptor baseEndpointDescriptor) {
        boolean matches = false;
        if (baseEndpointDescriptor.getOperationStringIdentifier() != null && baseEndpointDescriptor.getOperationStringIdentifier().equals(operationBuilder.getApiOperationId())) {
            matches = true;
        } else {
            String methodAndPath = String.format("%s-%s", operationBuilder.getHttpMethod().name(), operationBuilder.getPath());
            if (methodAndPath.equalsIgnoreCase(baseEndpointDescriptor.getOperationStringIdentifier())) {
                matches = true;
            }
        }
        return matches;
    }

    public Optional<TriggerBuilder> getTriggerBuildersByName(String triggerName) {
        return this.triggerBuilders.stream().filter(x -> triggerName.equals(x.getName())).findFirst();
    }

    public TriggerBuilder createTriggerAdapterBuilder(String triggerName, TriggerBuilder baseTriggerBuilder) {
        TriggerBuilder triggerBuilder = new TriggerBuilder(triggerName, baseTriggerBuilder);
        this.triggerBuilders.add(triggerBuilder);
        return triggerBuilder;
    }

    public OperationBuilder createOperationAdapterBuilder(String descriptorIdentifier, OperationBuilder baseOperationBuilder) {
        OperationBuilder operationBuilder = new OperationBuilder(descriptorIdentifier, baseOperationBuilder);
        this.operationBuilders.add(operationBuilder);
        return operationBuilder;
    }

    public OperationBuilder createNativeOperationAdapterBuilder(String descriptorIdentifier, String fqn) {
        OperationBuilder operationBuilder = new OperationBuilder(descriptorIdentifier, fqn);
        this.operationBuilders.add(operationBuilder);
        return operationBuilder;
    }

    public OperationBuilder getOrCreateOperationBuilder(String apiOperationId, String apiPath, String apiMethod, String apiSummary, Documentation documentation) {
        Objects.requireNonNull(apiMethod, "API Method is required");
        Objects.requireNonNull(apiPath, "API Path is required");
        OperationBuilder operationBuilder = this.operationBuilders.stream().filter(x -> x.getPath().equalsIgnoreCase(apiPath) && x.getMethod().equalsIgnoreCase(apiMethod)).findFirst().orElse(null);
        if (operationBuilder == null) {
            operationBuilder = new OperationBuilder(apiOperationId, apiPath, apiMethod, apiSummary, documentation);
            this.operationBuilders.add(operationBuilder);
        }
        return operationBuilder;
    }

    public PaginationBuilder getOrCreatePaginationBuilder(String paginationName) {
        Objects.requireNonNull(paginationName, "Pagination Name is required");
        PaginationBuilder paginationBuilder = this.paginationBuilders.stream().filter(x -> x.getName().equals(paginationName)).findFirst().orElse(null);
        if (paginationBuilder == null) {
            paginationBuilder = new PaginationBuilder(paginationName);
            this.paginationBuilders.add(paginationBuilder);
        }
        return paginationBuilder;
    }

    public SecuritySchemeBuilder getOrCreateSecuritySchemeBuilder(String name, ConnectorSecurityScheme.SecuritySchemeType type) {
        Objects.requireNonNull(name, "Security scheme name is required");
        SecuritySchemeBuilder securitySchemeBuilder = this.securitySchemeBuilders.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (securitySchemeBuilder == null) {
            Objects.requireNonNull(type, String.format("Security Scheme named %s does not exist and a type was not specified. This is a bug.", name));
            securitySchemeBuilder = new SecuritySchemeBuilder(name, type);
            this.securitySchemeBuilders.add(securitySchemeBuilder);
        }
        if (type != null) {
            if (type.equals((Object)ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION) && securitySchemeBuilder.getType().equals((Object)ConnectorSecurityScheme.SecuritySchemeType.UNSECURED)) {
                securitySchemeBuilder.setType(ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION);
                return securitySchemeBuilder;
            }
            if (!securitySchemeBuilder.getType().equals((Object)type)) {
                throw new IllegalStateException("Security scheme type does not match. This is a bug.");
            }
        }
        return securitySchemeBuilder;
    }

    public List<TriggerBuilder> getTriggerBuilders() {
        return this.triggerBuilders;
    }

    public TriggerBuilder getOrCreateTriggerBuilder(String name) {
        Objects.requireNonNull(name, "Trigger name is required");
        TriggerBuilder triggerBuilder = this.triggerBuilders.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (triggerBuilder == null) {
            triggerBuilder = new TriggerBuilder(name);
            this.triggerBuilders.add(triggerBuilder);
        }
        return triggerBuilder;
    }

    public List<InterceptorBuilder> getInterceptorBuilders() {
        return this.interceptorBuilders;
    }

    public InterceptorBuilder createInterceptor() {
        InterceptorBuilder interceptorBuilder = new InterceptorBuilder();
        this.interceptorBuilders.add(interceptorBuilder);
        return interceptorBuilder;
    }

    public void setAllOperationsIgnored(Boolean ignoreOperations) {
        this.operationBuilders.forEach(x -> x.ignored(ignoreOperations));
        this.triggerBuilders.forEach(x -> x.ignored(ignoreOperations));
    }

    public ConnectorModel build() throws ModelGenerationException {
        Objects.requireNonNull(this.connectorName, "Connector name is required");
        TypeSchemaPool typeSchemaPool = new TypeSchemaPool();
        List<Pagination> paginations = this.paginationBuilders.stream().map(PaginationBuilder::build).collect(Collectors.toList());
        OperationDisplayNameExpressionHandler operationDisplayNameExpressionHandler = this.buildOperationDisplayNameHandler();
        OperationIdentifierExpressionHandler operationIdentifierExpressionHandler = this.buildOperationIdentifierHandler();
        ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler = this.buildParameterIdentifierHandler();
        BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler = this.buildBodyIdentifierHandler();
        List<ConnectorSecurityScheme> securitySchemes = this.buildSecuritySchemes(typeSchemaPool, parameterIdentifierExpressionHandler);
        List<ConnectorOperation> operations = this.operationBuilders.stream().filter(operationBuilder -> StringUtils.isEmpty((CharSequence)operationBuilder.getFqn())).map(x -> x.build(operationIdentifierExpressionHandler, operationDisplayNameExpressionHandler, parameterIdentifierExpressionHandler, bodyIdentifierExpressionHandler, typeSchemaPool, paginations, securitySchemes, this.defaultInputMediaType, this.defaultOutputMediaType, this.buildQueryParamArrayFormat(), this.skipOutputTypeValidation)).collect(Collectors.toList());
        List nativeOperations = this.operationBuilders.stream().filter(operationBuilder -> StringUtils.isNotBlank((CharSequence)operationBuilder.getFqn())).map(x -> x.build()).collect(Collectors.toList());
        operations.addAll(nativeOperations);
        List<Trigger> triggers = this.triggerBuilders.stream().filter(x -> StringUtils.isEmpty((CharSequence)x.getFqn())).filter(x -> !x.isIgnored()).map(x -> x.build(operations, typeSchemaPool)).collect(Collectors.toList());
        List nativeTriggers = this.triggerBuilders.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getFqn())).filter(x -> !x.isIgnored()).map(x -> x.buildNative()).collect(Collectors.toList());
        triggers.addAll(nativeTriggers);
        return new ConnectorModel(this.buildConnectorName(), this.connectorDescription, this.buildMavenGroup(), this.buildMavenArtifactId(), this.buildMavenVersion(), this.buildBasePackage(), this.connectorCategory, this.buildBaseUri(operations, triggers), this.getSupportedProtocols(), operations.stream().filter(x -> !x.isIgnored()).collect(Collectors.toList()), paginations, this.buildExtensionXml(), triggers, this.interceptorBuilders.stream().map(x -> x.build()).collect(Collectors.toList()), this.connectorConfiguration);
    }

    private BaseUri buildBaseUri(List<ConnectorOperation> operations, List<Trigger> triggers) {
        if (!this.baseUriBuilder.hasUri()) {
            HashSet<String> uriSet = new HashSet<String>();
            uriSet.addAll(ConnectorModelBuilder.getOperationBaseUris(operations));
            uriSet.addAll(ConnectorModelBuilder.getTriggerBaseUris(triggers));
            if (uriSet.size() == 1) {
                this.baseUriBuilder.setUri((String)uriSet.iterator().next());
            }
        }
        return this.baseUriBuilder.build(this.supportedProtocols);
    }

    private static Set<String> getOperationBaseUris(List<ConnectorOperation> operations) {
        return operations.stream().filter(operation -> !operation.isIgnored()).map(ConnectorOperation::getBaseUris).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<String> getTriggerBaseUris(List<Trigger> triggers) {
        return triggers.stream().map(Trigger::getOperation).filter(Objects::nonNull).map(ConnectorOperation::getBaseUris).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private List<ConnectorSecurityScheme> buildSecuritySchemes(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        this.securitySchemeBuilders.add(new SecuritySchemeBuilder(ConnectorSecurityScheme.SecuritySchemeType.UNSECURED.toString(), ConnectorSecurityScheme.SecuritySchemeType.UNSECURED));
        return this.securitySchemeBuilders.stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(x -> x.build(typeSchemaPool, this.testConnectionConfig, parameterIdentifierExpressionHandler)).collect(Collectors.toList());
    }

    private String buildConnectorName() {
        return this.connectorName.trim();
    }

    private String buildMavenGroup() {
        return XmlUtils.removeMavenGroupUnwantedCharacters((String)this.mavenGroup);
    }

    private String buildMavenArtifactId() {
        return XmlUtils.removeMavenArtifactUnwantedCharacters((String)this.mavenArtifactId);
    }

    private String buildMavenVersion() {
        return XmlUtils.removeMavenVersionUnwantedCharacters((String)this.mavenVersion);
    }

    private List<Protocol> getSupportedProtocols() {
        return this.supportedProtocols != null && !this.supportedProtocols.isEmpty() ? this.supportedProtocols : Arrays.asList(DEFAULT_PROTOCOLS);
    }

    private String buildBasePackage() {
        return StringUtils.isNotBlank((CharSequence)this.baseJavaPackage) ? this.baseJavaPackage : ConnectorPackage.buildBasePackage(this.connectorName);
    }

    private String buildExtensionXml() {
        return StringUtils.isNotBlank((CharSequence)this.extensionXml) ? this.extensionXml : XmlUtils.getXmlName((String)this.connectorName);
    }

    private QueryParamArrayFormat buildQueryParamArrayFormat() {
        return (QueryParamArrayFormat)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.queryParamArrayFormat), (Object)((Object)QueryParamArrayFormat.MULTIMAP)));
    }

    private OperationIdentifierExpressionHandler buildOperationIdentifierHandler() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.operationIdentifierExpression) ? new OperationIdentifierExpressionHandler(this.operationIdentifierExpression) : new OperationIdentifierExpressionHandler();
        }
        catch (CompilationException e) {
            throw new IllegalArgumentException("The script for the 'operationIdentifier' failed to compile. This is a bug.", e);
        }
    }

    private OperationDisplayNameExpressionHandler buildOperationDisplayNameHandler() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.operationDisplayNameExpression) ? new OperationDisplayNameExpressionHandler(this.operationDisplayNameExpression) : new OperationDisplayNameExpressionHandler();
        }
        catch (CompilationException e) {
            throw new IllegalArgumentException("The script for the 'operationDisplayName' failed to compile. This is a bug.", e);
        }
    }

    private ParameterIdentifierExpressionHandler buildParameterIdentifierHandler() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.parameterIdentifierExpression) ? new ParameterIdentifierExpressionHandler(this.parameterIdentifierExpression) : new ParameterIdentifierExpressionHandler();
        }
        catch (CompilationException e) {
            throw new IllegalArgumentException("The script for the 'parameterIdentifier' failed to compile. This is a bug.", e);
        }
    }

    private BodyIdentifierExpressionHandler buildBodyIdentifierHandler() {
        try {
            return StringUtils.isNotBlank((CharSequence)this.bodyIdentifierExpression) ? new BodyIdentifierExpressionHandler(this.bodyIdentifierExpression) : new BodyIdentifierExpressionHandler();
        }
        catch (CompilationException e) {
            throw new IllegalArgumentException("The script for the 'bodyIdentifier' failed to compile. This is a bug.", e);
        }
    }
}

