/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.metadata.MetadataKeyBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.PartParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;

public class ParameterBuilder {
    private final String externalName;
    private final ParameterType parameterType;
    private String parameterIdentifier;
    private String displayName;
    private String muleAlias;
    private String muleMetadataKeyId;
    private final TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
    private String description;
    private Boolean required;
    private String defaultValue;
    private Boolean password;
    private Boolean filePart;
    private final ValueProviderBuilder valueProviderExpressionBuilder = new ValueProviderBuilder();
    private Boolean ignored;
    private String summary;
    private final MetadataKeyBuilder metadataKeyBuilder = new MetadataKeyBuilder();

    public ParameterBuilder(ParameterType parameterType, String externalName, String parameterIdentifier) {
        Objects.requireNonNull(parameterType);
        Objects.requireNonNull(externalName);
        this.parameterType = parameterType;
        this.externalName = externalName;
        this.parameterIdentifier = parameterIdentifier;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getParameterIdentifier() {
        return this.parameterIdentifier;
    }

    public ParameterBuilder parameterIdentifier(String parameterIdentifier) {
        this.parameterIdentifier = (String)ObjectUtils.defaultIfNull((Object)parameterIdentifier, (Object)this.parameterIdentifier);
        return this;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public Boolean isIgnored() {
        return this.ignored;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public ParameterBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public TypeDefinitionBuilder getTypeDefinitionBuilder() {
        return this.typeDefinitionBuilder;
    }

    public ParameterBuilder description(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public String getMuleAlias() {
        return this.muleAlias;
    }

    public String getMuleMetadataKeyId() {
        return this.muleMetadataKeyId;
    }

    public ParameterBuilder muleAlias(String muleAlias) {
        this.muleAlias = (String)ObjectUtils.defaultIfNull((Object)muleAlias, (Object)this.muleAlias);
        return this;
    }

    public ParameterBuilder muleMetadataKeyId(String muleMetadataKeyId) {
        this.muleMetadataKeyId = (String)ObjectUtils.defaultIfNull((Object)muleMetadataKeyId, (Object)this.muleMetadataKeyId);
        return this;
    }

    public ParameterBuilder required(Boolean required) {
        this.required = (Boolean)ObjectUtils.defaultIfNull((Object)required, (Object)this.required);
        return this;
    }

    public ParameterBuilder defaultValue(String defaultValue) {
        this.defaultValue = (String)ObjectUtils.defaultIfNull((Object)defaultValue, (Object)this.defaultValue);
        return this;
    }

    public ParameterBuilder password(Boolean password) {
        this.password = (Boolean)ObjectUtils.defaultIfNull((Object)password, (Object)this.password);
        return this;
    }

    public ParameterBuilder filePart(Boolean isFilePart) {
        this.filePart = (Boolean)ObjectUtils.defaultIfNull((Object)isFilePart, (Object)this.filePart);
        return this;
    }

    public ParameterBuilder partType(Boolean isFilePart) {
        this.filePart = (Boolean)ObjectUtils.defaultIfNull((Object)isFilePart, (Object)this.filePart);
        return this;
    }

    public ParameterBuilder ignored(Boolean ignored) {
        this.ignored = (Boolean)ObjectUtils.defaultIfNull((Object)ignored, (Object)this.ignored);
        return this;
    }

    public ParameterBuilder summary(String summary) {
        this.summary = (String)ObjectUtils.defaultIfNull((Object)summary, (Object)this.summary);
        return this;
    }

    public ValueProviderBuilder getValueProviderBuilder() {
        return this.valueProviderExpressionBuilder;
    }

    public MetadataKeyBuilder getMetadataKeyBuilder() {
        return this.metadataKeyBuilder;
    }

    public Parameter buildParameter(TypeSchemaPool typeSchemaPool, Optional<ParameterIdentifierExpressionHandler> parameterIdentifierExpressionHandlerOptional) {
        Parameter parameter = new Parameter(this.buildDisplayName(), this.externalName, this.buildParameterIdentifier(parameterIdentifierExpressionHandlerOptional), this.parameterType, this.buildParameterTypeDefinition(typeSchemaPool), this.muleAlias, this.description, this.required == null || this.required != false, this.defaultValue, this.password != null && this.password != false, this.valueProviderExpressionBuilder.build(), this.muleMetadataKeyId, null, null, null, this.summary, this.metadataKeyBuilder.build());
        return parameter;
    }

    public Parameter buildParameter(TypeSchemaPool typeSchemaPool, ParameterIdentifierExpressionHandler parameterIdentifierExpressionHandler) {
        return this.buildParameter(typeSchemaPool, Optional.ofNullable(parameterIdentifierExpressionHandler));
    }

    private String buildParameterIdentifier(Optional<ParameterIdentifierExpressionHandler> parameterIdentifierExpressionHandlerOptional) {
        String result = this.parameterIdentifier;
        if (this.parameterIdentifier == null && parameterIdentifierExpressionHandlerOptional.isPresent()) {
            ParameterIdentifierExpressionHandler.TypeParam typeParam = ParameterIdentifierExpressionHandler.TypeParam.valueOf(this.parameterType.toString());
            result = parameterIdentifierExpressionHandlerOptional.get().evaluate(this.externalName, typeParam);
        }
        return result;
    }

    public PartParameter buildPartParameter(TypeSchemaPool typeSchemaPool) {
        if (!this.parameterType.equals((Object)ParameterType.PART)) {
            throw new IllegalArgumentException("Parameter type not supported. This is a bug.");
        }
        Objects.requireNonNull(this.typeDefinitionBuilder);
        return new PartParameter(this.parameterIdentifier, this.buildDisplayName(), this.externalName, this.buildParameterTypeDefinition(typeSchemaPool), this.description, this.filePart != null && this.filePart != false, this.summary);
    }

    private String buildDisplayName() {
        return NamingUtil.makeNameFriendly(this.externalName);
    }

    private TypeDefinition buildParameterTypeDefinition(TypeSchemaPool typeSchemaPool) {
        if (this.typeDefinitionBuilder.canBuild()) {
            return this.typeDefinitionBuilder.build(typeSchemaPool, null);
        }
        return new TypeDefinitionBuilder().primitive(PrimitiveTypeDefinition.PrimitiveType.STRING).build(typeSchemaPool, null);
    }
}

