/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBindingBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.NativeTrigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TriggerBuilder {
    public static final String DEFAULT_DW_START_VALUE = "#[now()]";
    private final String name;
    private String operationId;
    private String path;
    private HTTPMethod method;
    private String displayName;
    private String description;
    private String alias;
    private String itemsExpression;
    private String identityExpression;
    private String requestBodyExpression;
    private String watermarkExpression;
    private ParameterDataType watermarkType;
    private List<TriggerParameterBuilder> parameterBuilders = new ArrayList<TriggerParameterBuilder>();
    private List<ParameterBindingBuilder> parameterBindingBuilders = new ArrayList<ParameterBindingBuilder>();
    private String outputTypeSchema;
    private String outputMediaType;
    private String muleMetadataScope;
    private SampleDataBuilder sampleDataBuilder = new SampleDataBuilder();
    private Boolean ignored;
    private String eventExpression;
    private String startValue;
    private boolean isSidecar;
    private String fqn;
    private Boolean refined;

    TriggerBuilder(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    TriggerBuilder(String name, TriggerBuilder baseTriggerBuilder) {
        this.name = name;
        this.operationId = baseTriggerBuilder.operationId;
        this.path = baseTriggerBuilder.path;
        this.method = baseTriggerBuilder.method;
        this.displayName = baseTriggerBuilder.displayName;
        this.description = baseTriggerBuilder.description;
        this.alias = baseTriggerBuilder.alias;
        this.itemsExpression = baseTriggerBuilder.itemsExpression;
        this.identityExpression = baseTriggerBuilder.identityExpression;
        this.requestBodyExpression = baseTriggerBuilder.requestBodyExpression;
        this.watermarkExpression = baseTriggerBuilder.watermarkExpression;
        this.watermarkType = baseTriggerBuilder.watermarkType;
        this.parameterBuilders = baseTriggerBuilder.parameterBuilders.stream().map(TriggerParameterBuilder::new).collect(Collectors.toList());
        this.parameterBindingBuilders = baseTriggerBuilder.parameterBindingBuilders.stream().map(ParameterBindingBuilder::new).collect(Collectors.toList());
        this.outputTypeSchema = baseTriggerBuilder.outputTypeSchema;
        this.outputMediaType = baseTriggerBuilder.outputMediaType;
        this.muleMetadataScope = baseTriggerBuilder.muleMetadataScope;
        this.sampleDataBuilder = new SampleDataBuilder(baseTriggerBuilder.sampleDataBuilder);
        this.eventExpression = baseTriggerBuilder.eventExpression;
        this.startValue = baseTriggerBuilder.startValue;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public TriggerBuilder operationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public TriggerBuilder path(String path) {
        this.path = (String)ObjectUtils.defaultIfNull((Object)path, (Object)this.path);
        return this;
    }

    public TriggerBuilder method(HTTPMethod method) {
        this.method = (HTTPMethod)((Object)ObjectUtils.defaultIfNull((Object)((Object)method), (Object)((Object)this.method)));
        return this;
    }

    public TriggerBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TriggerBuilder setDescription(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public TriggerBuilder alias(String alias) {
        this.alias = (String)ObjectUtils.defaultIfNull((Object)alias, (Object)this.alias);
        return this;
    }

    public TriggerBuilder itemsExpression(String itemsExpression) {
        this.itemsExpression = (String)ObjectUtils.defaultIfNull((Object)itemsExpression, (Object)this.itemsExpression);
        return this;
    }

    public String getItemsExpression() {
        return this.itemsExpression;
    }

    public TriggerBuilder identityExpression(String identityExpression) {
        this.identityExpression = (String)ObjectUtils.defaultIfNull((Object)identityExpression, (Object)this.identityExpression);
        return this;
    }

    public TriggerBuilder eventExpression(String eventExpression) {
        this.eventExpression = (String)ObjectUtils.defaultIfNull((Object)eventExpression, (Object)this.eventExpression);
        return this;
    }

    public TriggerBuilder startValue(String startValue) {
        if (StringUtils.isBlank((CharSequence)startValue)) {
            startValue = DEFAULT_DW_START_VALUE;
        }
        this.startValue = (String)ObjectUtils.defaultIfNull((Object)startValue, (Object)this.startValue);
        return this;
    }

    public TriggerBuilder requestBodyExpression(String requestBodyExpression) {
        this.requestBodyExpression = (String)ObjectUtils.defaultIfNull((Object)requestBodyExpression, (Object)this.requestBodyExpression);
        return this;
    }

    public TriggerBuilder watermarkExpression(String watermarkExpression) {
        this.watermarkExpression = (String)ObjectUtils.defaultIfNull((Object)watermarkExpression, (Object)this.watermarkExpression);
        return this;
    }

    public TriggerBuilder watermarkType(ParameterDataType watermarkType) {
        this.watermarkType = (ParameterDataType)((Object)ObjectUtils.defaultIfNull((Object)((Object)watermarkType), (Object)((Object)this.watermarkType)));
        return this;
    }

    public TriggerBuilder outputTypeSchema(String outputTypeSchema) {
        this.outputTypeSchema = (String)ObjectUtils.defaultIfNull((Object)outputTypeSchema, (Object)this.outputTypeSchema);
        return this;
    }

    public String getOutputTypeSchema() {
        return this.outputTypeSchema;
    }

    public TriggerBuilder outputMediaType(String outputMediaType) {
        this.outputMediaType = (String)ObjectUtils.defaultIfNull((Object)outputMediaType, (Object)this.outputMediaType);
        return this;
    }

    public TriggerBuilder muleMetadataScope(String muleMetadataScope) {
        this.muleMetadataScope = muleMetadataScope;
        return this;
    }

    public String getMuleMetadataScope() {
        return this.muleMetadataScope;
    }

    public TriggerBuilder ignored(Boolean ignored) {
        this.ignored = (Boolean)ObjectUtils.defaultIfNull((Object)ignored, (Object)this.ignored);
        return this;
    }

    public TriggerBuilder refined(Boolean refined) {
        this.refined = (Boolean)ObjectUtils.defaultIfNull((Object)refined, (Object)this.refined);
        return this;
    }

    public TriggerBuilder sidecar() {
        this.isSidecar = true;
        return this;
    }

    public TriggerBuilder fqn(String fqn) {
        this.fqn = (String)ObjectUtils.defaultIfNull((Object)fqn, (Object)this.fqn);
        return this;
    }

    public ParameterBindingBuilder getOrCreateParameterBindingBuilder(String name, ParameterType parameterType) {
        ParameterBindingBuilder parameterBindingBuilder = this.parameterBindingBuilders.stream().filter(x -> x.getName().equals(name) && x.getParameterType().equals((Object)parameterType)).findFirst().orElse(null);
        if (parameterBindingBuilder == null) {
            parameterBindingBuilder = new ParameterBindingBuilder(name, parameterType);
            this.parameterBindingBuilders.add(parameterBindingBuilder);
        }
        return parameterBindingBuilder;
    }

    public TriggerParameterBuilder getOrCreateParameterBuilder(String name) {
        TriggerParameterBuilder parameterBuilder = this.parameterBuilders.stream().filter(x -> x.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
        if (parameterBuilder == null) {
            parameterBuilder = new TriggerParameterBuilder(name);
            this.parameterBuilders.add(parameterBuilder);
        }
        return parameterBuilder;
    }

    public SampleDataBuilder getSampleDataExpressionBuilder() {
        return this.sampleDataBuilder;
    }

    Trigger buildNative() {
        return new NativeTrigger(this.name, this.fqn);
    }

    Trigger build(List<ConnectorOperation> operations, TypeSchemaPool typeSchemaPool) {
        ConnectorOperation operation = operations.stream().filter(op -> op.isAdapter() && op.getOperationIdentifier().equals(this.operationId)).findFirst().orElse(operations.stream().filter(op -> op.getHttpMethod().equals((Object)this.method) && op.getPath().equals(this.path)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid path/method for this trigger. This is a bug.")));
        Trigger trigger = new Trigger(this.name, this.displayName, this.description, this.alias, this.itemsExpression, this.identityExpression, this.requestBodyExpression, this.watermarkExpression, this.buildWatermarkType(this.watermarkType), this.parameterBuilders.stream().map(triggerParameterBuilder -> triggerParameterBuilder.build(typeSchemaPool)).collect(Collectors.toList()), this.parameterBindingBuilders.stream().map(ParameterBindingBuilder::build).collect(Collectors.toList()), this.getTriggerOutputType(operation, typeSchemaPool), this.outputMediaType, this.muleMetadataScope, this.eventExpression, this.startValue, this.isSidecar, null, (Boolean)ObjectUtils.defaultIfNull((Object)this.refined, (Object)false), operation);
        trigger.setSampleData(this.sampleDataBuilder.build(trigger));
        return trigger;
    }

    private ParameterDataType buildWatermarkType(ParameterDataType watermarkType) {
        if (watermarkType != null) {
            return watermarkType;
        }
        return ParameterDataType.STRING;
    }

    private TypeDefinition getTriggerOutputType(ConnectorOperation operation, TypeSchemaPool typeSchemaPool) {
        if (StringUtils.isNotBlank((CharSequence)this.muleMetadataScope)) {
            return null;
        }
        TypeDefinitionBuilder typeBuilder = new TypeDefinitionBuilder().object();
        if (StringUtils.isNotBlank((CharSequence)this.outputMediaType)) {
            typeBuilder.mediaType(MediaType.valueOf((String)this.outputMediaType));
        } else if (operation.getOutputMetadata() != null) {
            typeBuilder.mediaType(operation.getOutputMetadata().getMediaType());
        }
        if (operation.getOutputMetadata() != null && operation.getOutputMetadata().getTypeSchema() != null) {
            typeBuilder.typeSchema(() -> operation.getOutputMetadata().getTypeSchema().getRawSchema());
        }
        return typeBuilder.build(typeSchemaPool, this.outputTypeSchema, this.itemsExpression, MetadataUtils.LocationType.ITEM, false);
    }

    public boolean isIgnored() {
        return (Boolean)ObjectUtils.defaultIfNull((Object)this.ignored, (Object)false);
    }

    public boolean isSidecar() {
        return this.isSidecar;
    }

    public String getFqn() {
        return this.fqn;
    }
}

