/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiParameterLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APIPrimitiveType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.APITypeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APITypeSchemaModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.type.schema.APIXmlTypeSchemaModel;
import java.util.List;
import java.util.stream.Collectors;

public class ApiTypeLoader {
    public static void loadInputTypeDefinitions(List<APITypeModel> apiTypeModels, OperationBuilder connectorOperationBuilder) {
        for (APITypeModel apiTypeModel : apiTypeModels) {
            TypeDefinitionBuilder inputMetadataBuilder = connectorOperationBuilder.getOrCreateInputMetadataBuilder(apiTypeModel.getMediaType());
            ApiTypeLoader.loadTypeDefinition(apiTypeModel, inputMetadataBuilder);
        }
    }

    public static void loadOutputTypeDefinitions(List<APITypeModel> apiTypeModels, OperationBuilder connectorOperationBuilder) {
        for (APITypeModel apiTypeModel : apiTypeModels) {
            TypeDefinitionBuilder outputMetadataBuilder = connectorOperationBuilder.getOrCreateOutputMetadataBuilder(apiTypeModel.getMediaType());
            ApiTypeLoader.loadTypeDefinition(apiTypeModel, outputMetadataBuilder);
        }
    }

    static TypeDefinitionBuilder loadTypeDefinition(APITypeModel apiTypeModel, TypeDefinitionBuilder typeDefinitionBuilder) {
        typeDefinitionBuilder.displayName(apiTypeModel.getDisplayName()).description(apiTypeModel.getDescription()).enumValues(apiTypeModel.getEnumValues()).example(apiTypeModel.getExample()).mediaType(apiTypeModel.getMediaType()).required(apiTypeModel.isRequired());
        APITypeSchemaModel typeSchema = apiTypeModel.getAPITypeSchemaModel();
        if (typeSchema != null) {
            typeDefinitionBuilder.typeSchema(typeSchema.getSchemaSupplier());
            if (typeSchema instanceof APIXmlTypeSchemaModel) {
                typeDefinitionBuilder.elementName(((APIXmlTypeSchemaModel)typeSchema).getElementName());
                typeDefinitionBuilder.schemaPath(((APIXmlTypeSchemaModel)typeSchema).getPath());
            }
        }
        if (apiTypeModel.getApiType() == null) {
            return typeDefinitionBuilder;
        }
        switch (apiTypeModel.getApiType()) {
            case ARRAY: {
                typeDefinitionBuilder.array(ApiTypeLoader.loadTypeDefinition(apiTypeModel.getInnerType(), new TypeDefinitionBuilder()));
                break;
            }
            case EMPTY: {
                typeDefinitionBuilder.empty();
                break;
            }
            case MULTIPART: {
                List<ParameterBuilder> partParameterBuilders = apiTypeModel.getParts().stream().map(x -> {
                    String parameterIdentifier = null;
                    return ApiParameterLoader.loadParameter(x, new ParameterBuilder(ParameterType.PART, x.getExternalName(), parameterIdentifier));
                }).collect(Collectors.toList());
                typeDefinitionBuilder.multipart(partParameterBuilders);
                break;
            }
            case PRIMITIVE: {
                typeDefinitionBuilder.primitive(ApiTypeLoader.buildPrimitiveType(apiTypeModel.getPrimitiveType()));
                break;
            }
            case UNION_TYPE: {
                List<TypeDefinitionBuilder> unionTypeBuilders = apiTypeModel.getUnionTypes().stream().map(x -> ApiTypeLoader.loadTypeDefinition(x, new TypeDefinitionBuilder())).collect(Collectors.toList());
                typeDefinitionBuilder.union(unionTypeBuilders);
                break;
            }
            case OBJECT_TYPE: {
                typeDefinitionBuilder.object();
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported. This is a bug.");
            }
        }
        return typeDefinitionBuilder;
    }

    private static PrimitiveTypeDefinition.PrimitiveType buildPrimitiveType(APIPrimitiveType apiPrimitiveType) {
        switch (apiPrimitiveType) {
            case BOOLEAN: {
                return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
            }
            case DATE: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE;
            }
            case DATE_ONLY: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY;
            }
            case DATE_TIME_ONLY: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY;
            }
            case DATE_TIME: {
                return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME;
            }
            case FILE: {
                return PrimitiveTypeDefinition.PrimitiveType.FILE;
            }
            case NUMBER: {
                return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
            }
            case INTEGER: {
                return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
            }
            case LONG: {
                return PrimitiveTypeDefinition.PrimitiveType.LONG;
            }
            case STRING: {
                return PrimitiveTypeDefinition.PrimitiveType.STRING;
            }
            case TIME_ONLY: {
                return PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY;
            }
        }
        throw new IllegalArgumentException("Primitive Type not supported. This is a bug.");
    }
}

