/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.metadata.OverrideResolver;

import java.util.List;

public class Body {

  private final String bodyIdentifier;
  private final List<Field> fields;
  private final OverrideResolver overrideResolver;

  public Body(String bodyIdentifier, List<Field> fields, OverrideResolver overrideResolver) {
    this.bodyIdentifier = bodyIdentifier;
    this.fields = fields;
    this.overrideResolver = overrideResolver;
  }

  public String getBodyIdentifier() {
    return bodyIdentifier;
  }

  public List<Field> getFields() {
    return fields;
  }

  public OverrideResolver getOverrideResolver() {
    return overrideResolver;
  }
}
